"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled = false) {
  const {
    dataStreamService
  } = services;
  let getDataStreamsQuerySchema = {
    search: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  if (dataSourceEnabled) {
    getDataStreamsQuerySchema = {
      ...getDataStreamsQuerySchema,
      dataSourceId: _configSchema.schema.string()
    };
  }
  router.get({
    path: _constants.NODE_API._DATA_STREAMS,
    validate: {
      query: _configSchema.schema.object(getDataStreamsQuerySchema)
    }
  }, dataStreamService.getDataStreams);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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