"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled = false) {
  const {
    commonService
  } = services;
  let query = _configSchema.schema.object({}, {
    unknowns: "allow"
  });
  if (dataSourceEnabled) {
    query = query.extends({
      dataSourceId: _configSchema.schema.string()
    });
  }
  let bodySchema = _configSchema.schema.nullable(_configSchema.schema.object({
    endpoint: _configSchema.schema.string(),
    data: _configSchema.schema.nullable(_configSchema.schema.any()),
    hideLog: _configSchema.schema.nullable(_configSchema.schema.boolean())
  }));
  const payload = {
    path: _constants.NODE_API.API_CALLER,
    validate: {
      body: bodySchema,
      query: query
    }
  };
  router.post(payload, commonService.apiCaller);

  // this api is called on the very first page load
  router.post({
    path: _constants.NODE_API.ACCOUNT_INFO,
    validate: {
      body: bodySchema
    }
  }, commonService.apiCaller);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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