"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled = false) {
  const {
    aliasService
  } = services;
  let getAliasesQueryParam = {
    search: _configSchema.schema.maybe(_configSchema.schema.string())
  };
  if (dataSourceEnabled) {
    getAliasesQueryParam = {
      ...getAliasesQueryParam,
      dataSourceId: _configSchema.schema.string()
    };
  }
  router.get({
    path: _constants.NODE_API._ALIASES,
    validate: {
      query: _configSchema.schema.object(getAliasesQueryParam)
    }
  }, aliasService.getAliases);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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