"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternManagementPlugin = void 0;
var _ismPlugin = _interopRequireDefault(require("./clusters/ism/ismPlugin"));
var _services = require("./services");
var _routes = require("../server/routes");
var _dataStreams = _interopRequireDefault(require("./routes/dataStreams"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class IndexPatternManagementPlugin {
  async setup(core, {
    dataSource
  }) {
    // create OpenSearch client that aware of ISM API endpoints
    const osDriver = core.opensearch.legacy.createClient("index_management", {
      plugins: [_ismPlugin.default]
    });
    const dataSourceEnabled = !!dataSource;

    // Initialize services
    const indexService = new _services.IndexService(osDriver, dataSourceEnabled);
    const dataStreamService = new _services.DataStreamService(osDriver, dataSourceEnabled);
    const policyService = new _services.PolicyService(osDriver, dataSourceEnabled);
    const managedIndexService = new _services.ManagedIndexService(osDriver, dataSourceEnabled);
    const rollupService = new _services.RollupService(osDriver, dataSourceEnabled);
    const transformService = new _services.TransformService(osDriver, dataSourceEnabled);
    const notificationService = new _services.NotificationService(osDriver, dataSourceEnabled);
    const snapshotManagementService = new _services.SnapshotManagementService(osDriver, dataSourceEnabled);
    const commonService = new _services.CommonService(osDriver, dataSourceEnabled);
    const aliasService = new _services.AliasServices(osDriver, dataSourceEnabled);
    const services = {
      indexService,
      dataStreamService,
      policyService,
      managedIndexService,
      rollupService,
      transformService,
      notificationService,
      snapshotManagementService,
      commonService,
      aliasService
    };
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_ismPlugin.default);
    }

    // create router
    const router = core.http.createRouter();

    // Add server routes
    (0, _routes.indices)(services, router, dataSourceEnabled);
    (0, _dataStreams.default)(services, router, dataSourceEnabled);
    (0, _routes.policies)(services, router, dataSourceEnabled);
    (0, _routes.managedIndices)(services, router, dataSourceEnabled);
    (0, _routes.rollups)(services, router, dataSourceEnabled);
    (0, _routes.transforms)(services, router, dataSourceEnabled);
    (0, _routes.notifications)(services, router, dataSourceEnabled);
    (0, _routes.snapshotManagement)(services, router, dataSourceEnabled);
    (0, _routes.common)(services, router, dataSourceEnabled);
    (0, _routes.aliases)(services, router, dataSourceEnabled);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.IndexPatternManagementPlugin = IndexPatternManagementPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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