"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ismPlugin;
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
    TODO: migrate to types
 * Types are not available until 7.2
 * https://github.com/opensearch-project/OpenSearch-Dashboards/blob/main/src/core/server/opensearch/client/client_config.ts
 * */
function ismPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ism = components.clientAction.namespaceFactory();
  const ism = Client.prototype.ism.prototype;
  ism.getPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getPolicies = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}`
    },
    method: "GET"
  });
  ism.createPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deletePolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.putPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        },
        ifSeqNo: {
          type: "string",
          required: true
        },
        ifPrimaryTerm: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.explain = ca({
    url: {
      fmt: `${_constants.API.EXPLAIN_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.explainAll = ca({
    url: {
      fmt: `${_constants.API.EXPLAIN_BASE}`
    },
    method: "GET"
  });
  ism.retry = ca({
    url: {
      fmt: `${_constants.API.RETRY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: false,
    method: "POST"
  });
  ism.add = ca({
    url: {
      fmt: `${_constants.API.ADD_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  });
  ism.remove = ca({
    url: {
      fmt: `${_constants.API.REMOVE_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: false,
    method: "POST"
  });
  ism.change = ca({
    url: {
      fmt: `${_constants.API.CHANGE_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  });

  // TODO add new APIs as they are being implemented: status, stop, start

  ism.getRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getRollups = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}`
    },
    method: "GET"
  });
  ism.createRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>?refresh=wait_for`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deleteRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>?refresh=wait_for`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.putRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "PUT"
  });
  ism.startRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_start`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_stop`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.explainRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_explain`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getTransforms = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/`
    },
    method: "GET"
  });
  ism.explainTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_explain`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.startTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_start`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_stop`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.deleteTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.createTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>?refresh=wait_for`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.putTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "PUT"
  });
  ism.previewTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/_preview`
    },
    needBody: true,
    method: "POST"
  });
  ism.getChannels = ca({
    url: {
      fmt: `${_constants.API.CHANNELS_BASE}`
    },
    method: "GET"
  });
  ism.getChannel = ca({
    url: {
      fmt: `${_constants.API.NOTIFICATION_CONFIGS_BASE}/<%=id%>`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getSMPolicies = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}`
    },
    method: "GET"
  });
  ism.createSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  });
  ism.updateSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        },
        ifSeqNo: {
          type: "string",
          required: true
        },
        ifPrimaryTerm: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deleteSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.explainSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_explain`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.startSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_start`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_stop`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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