"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createISMCluster;
var _ismPlugin = _interopRequireDefault(require("./ismPlugin"));
var _constants = require("../../utils/constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createISMCluster(server) {
  const {
    customHeaders,
    ...rest
  } = server.config().get("opensearch");
  server.plugins.opensearch.createCluster(_constants.CLUSTER.ISM, {
    plugins: [_ismPlugin.default],
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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