"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClientBasedOnDataSource = getClientBasedOnDataSource;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function getClientBasedOnDataSource(context, dataSourceEnabled, request, dataSourceId, client) {
  if (dataSourceEnabled && dataSourceId && dataSourceId.trim().length != 0) {
    // client for remote cluster
    return context.dataSource.opensearch.legacy.getClient(dataSourceId).callAPI;
  } else {
    // fall back to default local cluster
    return client.asScoped(request).callAsCurrentUser;
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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