"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLRoutesService = void 0;
exports.registerMLRoutes = registerMLRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
var _helpers = require("./helpers");
var _helpers2 = require("../utils/helpers");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
/**
 * Server-side routes to process ml-plugin-related node API calls and execute the
 * corresponding API calls against the OpenSearch cluster.
 */
function registerMLRoutes(router, mlRoutesService) {
  router.post({
    path: _common.SEARCH_MODELS_NODE_API_PATH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, mlRoutesService.searchModels);
  router.post({
    path: `${_common.BASE_NODE_API_PATH}/{data_source_id}/model/search`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        data_source_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.searchModels);
  router.post({
    path: _common.SEARCH_CONNECTORS_NODE_API_PATH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, mlRoutesService.searchConnectors);
  router.post({
    path: `${_common.BASE_NODE_API_PATH}/{data_source_id}/connector/search`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        data_source_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.searchConnectors);
  router.post({
    path: _common.REGISTER_AGENT_NODE_API_PATH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, mlRoutesService.registerAgent);
  router.post({
    path: `${_common.BASE_NODE_API_PATH}/{data_source_id}/agent/register`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        data_source_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.registerAgent);
  router.post({
    path: _common.SEARCH_AGENTS_NODE_API_PATH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, mlRoutesService.searchAgents);
  router.post({
    path: `${_common.BASE_NODE_API_PATH}/{data_source_id}/agent/search`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        data_source_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.searchAgents);
  router.get({
    path: `${_common.GET_AGENT_NODE_API_PATH}/{agent_id}`,
    validate: {
      params: _configSchema.schema.object({
        agent_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.getAgent);
  router.get({
    path: `${_common.BASE_NODE_API_PATH}/{data_source_id}/agent/{agent_id}`,
    validate: {
      params: _configSchema.schema.object({
        data_source_id: _configSchema.schema.string(),
        agent_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.getAgent);
  router.put({
    path: `${_common.UPDATE_AGENT_NODE_API_PATH}/{agent_id}`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        agent_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.updateAgent);
  router.put({
    path: `${_common.BASE_NODE_API_PATH}/{data_source_id}/agent/update/{agent_id}`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        data_source_id: _configSchema.schema.string(),
        agent_id: _configSchema.schema.string()
      })
    }
  }, mlRoutesService.updateAgent);
}
class MLRoutesService {
  constructor(client, dataSourceEnabled) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "searchModels", async (context, req, res) => {
      const body = req.body;
      try {
        const {
          data_source_id = ''
        } = req.params;
        const callWithRequest = (0, _helpers2.getClientBasedOnDataSource)(context, this.dataSourceEnabled, req, data_source_id, this.client);
        const modelsResponse = await callWithRequest('mlClient.searchModels', {
          body
        });
        const modelHits = modelsResponse.hits.hits;
        const modelDict = (0, _helpers.getModelsFromResponses)(modelHits);
        return res.ok({
          body: {
            models: modelDict
          }
        });
      } catch (err) {
        if ((0, _helpers.isIgnorableError)(err)) {
          return res.ok({
            body: {
              models: {}
            }
          });
        }
        return (0, _helpers.generateCustomError)(res, err);
      }
    });
    _defineProperty(this, "searchConnectors", async (context, req, res) => {
      const body = req.body;
      try {
        const {
          data_source_id = ''
        } = req.params;
        const callWithRequest = (0, _helpers2.getClientBasedOnDataSource)(context, this.dataSourceEnabled, req, data_source_id, this.client);
        const connectorsResponse = await callWithRequest('mlClient.searchConnectors', {
          body
        });
        const connectorHits = connectorsResponse.hits.hits;
        const connectorDict = (0, _helpers.getConnectorsFromResponses)(connectorHits);
        return res.ok({
          body: {
            connectors: connectorDict
          }
        });
      } catch (err) {
        if ((0, _helpers.isIgnorableError)(err)) {
          return res.ok({
            body: {
              connectors: {}
            }
          });
        }
        return (0, _helpers.generateCustomError)(res, err);
      }
    });
    _defineProperty(this, "registerAgent", async (context, req, res) => {
      const body = req.body;
      try {
        const {
          data_source_id = ''
        } = req.params;
        const callWithRequest = (0, _helpers2.getClientBasedOnDataSource)(context, this.dataSourceEnabled, req, data_source_id, this.client);
        const response = await callWithRequest('mlClient.registerAgent', {
          body
        });
        const agentWithId = {
          ...body,
          id: response.agent_id
        };
        return res.ok({
          body: {
            agent: agentWithId
          }
        });
      } catch (err) {
        return (0, _helpers.generateCustomError)(res, err);
      }
    });
    _defineProperty(this, "searchAgents", async (context, req, res) => {
      const body = req.body;
      try {
        const {
          data_source_id = ''
        } = req.params;
        const callWithRequest = (0, _helpers2.getClientBasedOnDataSource)(context, this.dataSourceEnabled, req, data_source_id, this.client);
        const agentResponse = await callWithRequest('mlClient.searchAgents', {
          body
        });
        const agentHits = agentResponse.hits.hits;
        const agentDict = (0, _helpers.getAgentsFromResponses)(agentHits);
        return res.ok({
          body: {
            agents: agentDict
          }
        });
      } catch (err) {
        if ((0, _helpers.isIgnorableError)(err)) {
          return res.ok({
            body: {
              agents: {}
            }
          });
        }
        return (0, _helpers.generateCustomError)(res, err);
      }
    });
    _defineProperty(this, "getAgent", async (context, req, res) => {
      try {
        const {
          data_source_id = ''
        } = req.params;
        const {
          agent_id
        } = req.params;
        const callWithRequest = (0, _helpers2.getClientBasedOnDataSource)(context, this.dataSourceEnabled, req, data_source_id, this.client);
        const response = await callWithRequest('mlClient.getAgent', {
          agent_id
        });
        const agent = (0, _helpers.toAgentObj)(response, agent_id);
        return res.ok({
          body: {
            agent
          }
        });
      } catch (err) {
        return (0, _helpers.generateCustomError)(res, err);
      }
    });
    _defineProperty(this, "updateAgent", async (context, req, res) => {
      try {
        var _body$parameters;
        const {
          data_source_id = ''
        } = req.params;
        const {
          agent_id
        } = req.params;
        const body = req.body;

        // There is a bug where the MCP connectors arr must be stringified in the request body, or it fails.
        // See https://github.com/opensearch-project/ml-commons/issues/4321
        const bodyWithStringifiedMcpConnectors = {
          ...body,
          parameters: {
            ...body.parameters,
            mcp_connectors: JSON.stringify((_body$parameters = body.parameters) === null || _body$parameters === void 0 ? void 0 : _body$parameters.mcp_connectors)
          }
        };
        const callWithRequest = (0, _helpers2.getClientBasedOnDataSource)(context, this.dataSourceEnabled, req, data_source_id, this.client);
        await callWithRequest('mlClient.updateAgent', {
          agent_id,
          body: bodyWithStringifiedMcpConnectors
        });

        // format the response to be what was passed to the API call, since the update API does not
        // return the updated agent body itself.
        const agent = (0, _helpers.toAgentObj)(bodyWithStringifiedMcpConnectors, agent_id);
        return res.ok({
          body: {
            agent
          }
        });
      } catch (err) {
        return (0, _helpers.generateCustomError)(res, err);
      }
    });
    this.client = client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.MLRoutesService = MLRoutesService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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