"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlowFrameworkDashboardsPlugin = void 0;
var _operators = require("rxjs/operators");
var _cluster = require("./cluster");
var _routes = require("./routes");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class FlowFrameworkDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core, {
    dataSource
  }) {
    this.logger.debug('flow-framework-dashboards: Setup');
    const router = core.http.createRouter();

    // Get global config
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();

    // Create OpenSearch client, including flow framework plugin APIs
    const client = core.opensearch.legacy.createClient('flow_framework', {
      plugins: [_cluster.flowFrameworkPlugin, _cluster.mlPlugin, _cluster.corePlugin],
      ...globalConfig.opensearch
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_cluster.flowFrameworkPlugin);
      dataSource.registerCustomApiSchema(_cluster.mlPlugin);
      dataSource.registerCustomApiSchema(_cluster.corePlugin);
    }
    const opensearchRoutesService = new _routes.OpenSearchRoutesService(client, dataSourceEnabled);
    const flowFrameworkRoutesService = new _routes.FlowFrameworkRoutesService(client, dataSourceEnabled);
    const mlRoutesService = new _routes.MLRoutesService(client, dataSourceEnabled);

    // Register server side APIs with the corresponding service functions
    (0, _routes.registerOpenSearchRoutes)(router, opensearchRoutesService);
    (0, _routes.registerFlowFrameworkRoutes)(router, flowFrameworkRoutesService);
    (0, _routes.registerMLRoutes)(router, mlRoutesService);
    return {};
  }
  start(core) {
    this.logger.debug('flow-framework-dashboards: Started');
    return {};
  }
  stop() {}
}
exports.FlowFrameworkDashboardsPlugin = FlowFrameworkDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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