"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlPlugin = mlPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Used during the plugin's setup() lifecycle phase to register various client actions
 * representing ML plugin APIs. These are then exposed and used on the
 * server-side when processing node APIs - see server/routes/ml_routes_service
 * for examples.
 */
function mlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.mlClient = components.clientAction.namespaceFactory();
  const mlClient = Client.prototype.mlClient.prototype;
  mlClient.searchModels = ca({
    url: {
      fmt: _common.ML_SEARCH_MODELS_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.searchConnectors = ca({
    url: {
      fmt: _common.ML_SEARCH_CONNECTORS_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.registerAgent = ca({
    url: {
      fmt: _common.ML_REGISTER_AGENT_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.updateAgent = ca({
    url: {
      fmt: `${_common.ML_AGENT_ROUTE_PREFIX}/<%=agent_id%>`,
      req: {
        agent_id: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  mlClient.searchAgents = ca({
    url: {
      fmt: _common.ML_SEARCH_AGENTS_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.getAgent = ca({
    url: {
      fmt: `${_common.ML_AGENT_ROUTE_PREFIX}/<%=agent_id%>`,
      req: {
        agent_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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