"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flowFrameworkPlugin = flowFrameworkPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Used during the plugin's setup() lifecycle phase to register various client actions
 * representing Flow Framework plugin APIs. These are then exposed and used on the
 * server-side when processing node APIs - see server/routes/flow_framework_routes_service
 * for examples.
 */
function flowFrameworkPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.flowFramework = components.clientAction.namespaceFactory();
  const flowFramework = Client.prototype.flowFramework.prototype;
  flowFramework.getWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  flowFramework.searchWorkflows = ca({
    url: {
      fmt: _common.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE
    },
    needBody: true,
    // Exposed client rejects making GET requests with a body. So, we use POST
    method: 'POST'
  });
  flowFramework.getWorkflowState = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_status`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  flowFramework.searchWorkflowState = ca({
    url: {
      fmt: _common.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE
    },
    needBody: true,
    // Exposed client rejects making GET requests with a body. So, we use POST
    method: 'POST'
  });
  flowFramework.createWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}?provision=false`
    },
    needBody: true,
    method: 'POST'
  });
  flowFramework.updateWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>?update_fields=<%=update_fields%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        update_fields: {
          type: 'boolean',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  flowFramework.updateAndReprovisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>?update_fields=<%=update_fields%>&reprovision=true&wait_for_completion_timeout=${_common.PROVISION_TIMEOUT}`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        update_fields: {
          type: 'boolean',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  flowFramework.updateAndReprovisionWorkflowAsync = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>?update_fields=<%=update_fields%>&reprovision=true`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        update_fields: {
          type: 'boolean',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  flowFramework.provisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_provision?wait_for_completion_timeout=${_common.PROVISION_TIMEOUT}`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.provisionWorkflowAsync = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_provision`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.deprovisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_deprovision`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.forceDeprovisionWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>/_deprovision?allow_delete=<%=resource_ids%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        },
        resource_ids: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  flowFramework.deleteWorkflow = ca({
    url: {
      fmt: `${_common.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/<%=workflow_id%>`,
      req: {
        workflow_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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