"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.corePlugin = corePlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function corePlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.coreClient = components.clientAction.namespaceFactory();
  const coreClient = Client.prototype.coreClient.prototype;
  coreClient.getSearchPipeline = ca({
    url: {
      fmt: `${_common.SEARCH_PIPELINE_ROUTE}/<%=pipeline_id%>`,
      req: {
        pipeline_id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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