"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customStringify = customStringify;
exports.customStringifySingleLine = customStringifySingleLine;
exports.getCharacterLimitedString = getCharacterLimitedString;
exports.isDependentOnModels = isDependentOnModels;
exports.isRAGUseCase = isRAGUseCase;
exports.isVectorSearchUseCase = isVectorSearchUseCase;
exports.prettifyErrorMessage = void 0;
exports.toFormattedDate = toFormattedDate;
var _moment = _interopRequireDefault(require("moment"));
var _ = require("./");
var _lodash = require("lodash");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function toFormattedDate(timestampMillis) {
  return (0, _moment.default)(new Date(timestampMillis)).format(_.DATE_FORMAT_PATTERN);
}
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }
  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);
  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};
exports.prettifyErrorMessage = prettifyErrorMessage;
function getCharacterLimitedString(input, limit) {
  return input !== undefined ? input.length > limit ? input.substring(0, limit - 3) + '...' : input : '';
}
function customStringify(jsonObj) {
  return JSON.stringify(jsonObj, undefined, 2);
}
function customStringifySingleLine(jsonObj) {
  return JSON.stringify(jsonObj, undefined, 0);
}
function isDependentOnModels(workflowType) {
  return isVectorSearchUseCase(workflowType);
}
function isVectorSearchUseCase(workflowType) {
  return workflowType !== undefined && [_.WORKFLOW_TYPE.SEMANTIC_SEARCH, _.WORKFLOW_TYPE.MULTIMODAL_SEARCH, _.WORKFLOW_TYPE.HYBRID_SEARCH, _.WORKFLOW_TYPE.VECTOR_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.HYBRID_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.SEMANTIC_SEARCH_USING_SPARSE_ENCODERS].includes(workflowType);
}
function isRAGUseCase(workflowType) {
  return workflowType !== undefined && [_.WORKFLOW_TYPE.VECTOR_SEARCH_WITH_RAG, _.WORKFLOW_TYPE.HYBRID_SEARCH_WITH_RAG].includes(workflowType);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbW9tZW50IiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJfIiwiX2xvZGFzaCIsImUiLCJfX2VzTW9kdWxlIiwiZGVmYXVsdCIsInRvRm9ybWF0dGVkRGF0ZSIsInRpbWVzdGFtcE1pbGxpcyIsIm1vbWVudCIsIkRhdGUiLCJmb3JtYXQiLCJEQVRFX0ZPUk1BVF9QQVRURVJOIiwiUEVSTUlTU0lPTlNfRVJST1JfUEFUVEVSTiIsInByZXR0aWZ5RXJyb3JNZXNzYWdlIiwicmF3RXJyb3JNZXNzYWdlIiwiaXNFbXB0eSIsIm1hdGNoIiwiZXhwb3J0cyIsImdldENoYXJhY3RlckxpbWl0ZWRTdHJpbmciLCJpbnB1dCIsImxpbWl0IiwidW5kZWZpbmVkIiwibGVuZ3RoIiwic3Vic3RyaW5nIiwiY3VzdG9tU3RyaW5naWZ5IiwianNvbk9iaiIsIkpTT04iLCJzdHJpbmdpZnkiLCJjdXN0b21TdHJpbmdpZnlTaW5nbGVMaW5lIiwiaXNEZXBlbmRlbnRPbk1vZGVscyIsIndvcmtmbG93VHlwZSIsImlzVmVjdG9yU2VhcmNoVXNlQ2FzZSIsIldPUktGTE9XX1RZUEUiLCJTRU1BTlRJQ19TRUFSQ0giLCJNVUxUSU1PREFMX1NFQVJDSCIsIkhZQlJJRF9TRUFSQ0giLCJWRUNUT1JfU0VBUkNIX1dJVEhfUkFHIiwiSFlCUklEX1NFQVJDSF9XSVRIX1JBRyIsIlNFTUFOVElDX1NFQVJDSF9VU0lOR19TUEFSU0VfRU5DT0RFUlMiLCJpbmNsdWRlcyIsImlzUkFHVXNlQ2FzZSJdLCJzb3VyY2VzIjpbInV0aWxzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCBtb21lbnQgZnJvbSAnbW9tZW50JztcclxuaW1wb3J0IHsgREFURV9GT1JNQVRfUEFUVEVSTiwgV09SS0ZMT1dfVFlQRSB9IGZyb20gJy4vJztcclxuaW1wb3J0IHsgaXNFbXB0eSB9IGZyb20gJ2xvZGFzaCc7XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gdG9Gb3JtYXR0ZWREYXRlKHRpbWVzdGFtcE1pbGxpczogbnVtYmVyKTogU3RyaW5nIHtcclxuICByZXR1cm4gbW9tZW50KG5ldyBEYXRlKHRpbWVzdGFtcE1pbGxpcykpLmZvcm1hdChEQVRFX0ZPUk1BVF9QQVRURVJOKTtcclxufVxyXG5cclxuY29uc3QgUEVSTUlTU0lPTlNfRVJST1JfUEFUVEVSTiA9IC9ubyBwZXJtaXNzaW9ucyBmb3IgXFxbKC4rKVxcXSBhbmQgVXNlciBcXFtuYW1lPSguKyksIGJhY2tlbmRfcm9sZXMvO1xyXG5cclxuZXhwb3J0IGNvbnN0IHByZXR0aWZ5RXJyb3JNZXNzYWdlID0gKHJhd0Vycm9yTWVzc2FnZTogc3RyaW5nKSA9PiB7XHJcbiAgaWYgKGlzRW1wdHkocmF3RXJyb3JNZXNzYWdlKSB8fCByYXdFcnJvck1lc3NhZ2UgPT09ICd1bmRlZmluZWQnKSB7XHJcbiAgICByZXR1cm4gJ1Vua25vd24gZXJyb3IgaXMgcmV0dXJuZWQuJztcclxuICB9XHJcbiAgY29uc3QgbWF0Y2ggPSByYXdFcnJvck1lc3NhZ2UubWF0Y2goUEVSTUlTU0lPTlNfRVJST1JfUEFUVEVSTik7XHJcbiAgaWYgKGlzRW1wdHkobWF0Y2gpKSB7XHJcbiAgICByZXR1cm4gcmF3RXJyb3JNZXNzYWdlO1xyXG4gIH0gZWxzZSB7XHJcbiAgICByZXR1cm4gYFVzZXIgJHttYXRjaFsyXX0gaGFzIG5vIHBlcm1pc3Npb25zIHRvIFske21hdGNoWzFdfV0uYDtcclxuICB9XHJcbn07XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gZ2V0Q2hhcmFjdGVyTGltaXRlZFN0cmluZyhcclxuICBpbnB1dDogc3RyaW5nIHwgdW5kZWZpbmVkLFxyXG4gIGxpbWl0OiBudW1iZXJcclxuKTogc3RyaW5nIHtcclxuICByZXR1cm4gaW5wdXQgIT09IHVuZGVmaW5lZFxyXG4gICAgPyBpbnB1dC5sZW5ndGggPiBsaW1pdFxyXG4gICAgICA/IGlucHV0LnN1YnN0cmluZygwLCBsaW1pdCAtIDMpICsgJy4uLidcclxuICAgICAgOiBpbnB1dFxyXG4gICAgOiAnJztcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIGN1c3RvbVN0cmluZ2lmeShqc29uT2JqOiB7fSB8IFtdKTogc3RyaW5nIHtcclxuICByZXR1cm4gSlNPTi5zdHJpbmdpZnkoanNvbk9iaiwgdW5kZWZpbmVkLCAyKTtcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIGN1c3RvbVN0cmluZ2lmeVNpbmdsZUxpbmUoanNvbk9iajoge30pOiBzdHJpbmcge1xyXG4gIHJldHVybiBKU09OLnN0cmluZ2lmeShqc29uT2JqLCB1bmRlZmluZWQsIDApO1xyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gaXNEZXBlbmRlbnRPbk1vZGVscyh3b3JrZmxvd1R5cGU/OiBXT1JLRkxPV19UWVBFKTogYm9vbGVhbiB7XHJcbiAgcmV0dXJuIGlzVmVjdG9yU2VhcmNoVXNlQ2FzZSh3b3JrZmxvd1R5cGUpO1xyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gaXNWZWN0b3JTZWFyY2hVc2VDYXNlKHdvcmtmbG93VHlwZT86IFdPUktGTE9XX1RZUEUpOiBib29sZWFuIHtcclxuICByZXR1cm4gKFxyXG4gICAgd29ya2Zsb3dUeXBlICE9PSB1bmRlZmluZWQgJiZcclxuICAgIFtcclxuICAgICAgV09SS0ZMT1dfVFlQRS5TRU1BTlRJQ19TRUFSQ0gsXHJcbiAgICAgIFdPUktGTE9XX1RZUEUuTVVMVElNT0RBTF9TRUFSQ0gsXHJcbiAgICAgIFdPUktGTE9XX1RZUEUuSFlCUklEX1NFQVJDSCxcclxuICAgICAgV09SS0ZMT1dfVFlQRS5WRUNUT1JfU0VBUkNIX1dJVEhfUkFHLFxyXG4gICAgICBXT1JLRkxPV19UWVBFLkhZQlJJRF9TRUFSQ0hfV0lUSF9SQUcsXHJcbiAgICAgIFdPUktGTE9XX1RZUEUuU0VNQU5USUNfU0VBUkNIX1VTSU5HX1NQQVJTRV9FTkNPREVSUyxcclxuICAgIF0uaW5jbHVkZXMod29ya2Zsb3dUeXBlKVxyXG4gICk7XHJcbn1cclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBpc1JBR1VzZUNhc2Uod29ya2Zsb3dUeXBlPzogV09SS0ZMT1dfVFlQRSk6IGJvb2xlYW4ge1xyXG4gIHJldHVybiAoXHJcbiAgICB3b3JrZmxvd1R5cGUgIT09IHVuZGVmaW5lZCAmJlxyXG4gICAgW1xyXG4gICAgICBXT1JLRkxPV19UWVBFLlZFQ1RPUl9TRUFSQ0hfV0lUSF9SQUcsXHJcbiAgICAgIFdPUktGTE9XX1RZUEUuSFlCUklEX1NFQVJDSF9XSVRIX1JBRyxcclxuICAgIF0uaW5jbHVkZXMod29ya2Zsb3dUeXBlKVxyXG4gICk7XHJcbn1cclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O0FBS0EsSUFBQUEsT0FBQSxHQUFBQyxzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQUMsQ0FBQSxHQUFBRCxPQUFBO0FBQ0EsSUFBQUUsT0FBQSxHQUFBRixPQUFBO0FBQWlDLFNBQUFELHVCQUFBSSxDQUFBLFdBQUFBLENBQUEsSUFBQUEsQ0FBQSxDQUFBQyxVQUFBLEdBQUFELENBQUEsS0FBQUUsT0FBQSxFQUFBRixDQUFBO0FBUGpDO0FBQ0E7QUFDQTtBQUNBOztBQU1PLFNBQVNHLGVBQWVBLENBQUNDLGVBQXVCLEVBQVU7RUFDL0QsT0FBTyxJQUFBQyxlQUFNLEVBQUMsSUFBSUMsSUFBSSxDQUFDRixlQUFlLENBQUMsQ0FBQyxDQUFDRyxNQUFNLENBQUNDLHFCQUFtQixDQUFDO0FBQ3RFO0FBRUEsTUFBTUMseUJBQXlCLEdBQUcsaUVBQWlFO0FBRTVGLE1BQU1DLG9CQUFvQixHQUFJQyxlQUF1QixJQUFLO0VBQy9ELElBQUksSUFBQUMsZUFBTyxFQUFDRCxlQUFlLENBQUMsSUFBSUEsZUFBZSxLQUFLLFdBQVcsRUFBRTtJQUMvRCxPQUFPLDRCQUE0QjtFQUNyQztFQUNBLE1BQU1FLEtBQUssR0FBR0YsZUFBZSxDQUFDRSxLQUFLLENBQUNKLHlCQUF5QixDQUFDO0VBQzlELElBQUksSUFBQUcsZUFBTyxFQUFDQyxLQUFLLENBQUMsRUFBRTtJQUNsQixPQUFPRixlQUFlO0VBQ3hCLENBQUMsTUFBTTtJQUNMLE9BQVEsUUFBT0UsS0FBSyxDQUFDLENBQUMsQ0FBRSwyQkFBMEJBLEtBQUssQ0FBQyxDQUFDLENBQUUsSUFBRztFQUNoRTtBQUNGLENBQUM7QUFBQ0MsT0FBQSxDQUFBSixvQkFBQSxHQUFBQSxvQkFBQTtBQUVLLFNBQVNLLHlCQUF5QkEsQ0FDdkNDLEtBQXlCLEVBQ3pCQyxLQUFhLEVBQ0w7RUFDUixPQUFPRCxLQUFLLEtBQUtFLFNBQVMsR0FDdEJGLEtBQUssQ0FBQ0csTUFBTSxHQUFHRixLQUFLLEdBQ2xCRCxLQUFLLENBQUNJLFNBQVMsQ0FBQyxDQUFDLEVBQUVILEtBQUssR0FBRyxDQUFDLENBQUMsR0FBRyxLQUFLLEdBQ3JDRCxLQUFLLEdBQ1AsRUFBRTtBQUNSO0FBRU8sU0FBU0ssZUFBZUEsQ0FBQ0MsT0FBZ0IsRUFBVTtFQUN4RCxPQUFPQyxJQUFJLENBQUNDLFNBQVMsQ0FBQ0YsT0FBTyxFQUFFSixTQUFTLEVBQUUsQ0FBQyxDQUFDO0FBQzlDO0FBRU8sU0FBU08seUJBQXlCQSxDQUFDSCxPQUFXLEVBQVU7RUFDN0QsT0FBT0MsSUFBSSxDQUFDQyxTQUFTLENBQUNGLE9BQU8sRUFBRUosU0FBUyxFQUFFLENBQUMsQ0FBQztBQUM5QztBQUVPLFNBQVNRLG1CQUFtQkEsQ0FBQ0MsWUFBNEIsRUFBVztFQUN6RSxPQUFPQyxxQkFBcUIsQ0FBQ0QsWUFBWSxDQUFDO0FBQzVDO0FBRU8sU0FBU0MscUJBQXFCQSxDQUFDRCxZQUE0QixFQUFXO0VBQzNFLE9BQ0VBLFlBQVksS0FBS1QsU0FBUyxJQUMxQixDQUNFVyxlQUFhLENBQUNDLGVBQWUsRUFDN0JELGVBQWEsQ0FBQ0UsaUJBQWlCLEVBQy9CRixlQUFhLENBQUNHLGFBQWEsRUFDM0JILGVBQWEsQ0FBQ0ksc0JBQXNCLEVBQ3BDSixlQUFhLENBQUNLLHNCQUFzQixFQUNwQ0wsZUFBYSxDQUFDTSxxQ0FBcUMsQ0FDcEQsQ0FBQ0MsUUFBUSxDQUFDVCxZQUFZLENBQUM7QUFFNUI7QUFFTyxTQUFTVSxZQUFZQSxDQUFDVixZQUE0QixFQUFXO0VBQ2xFLE9BQ0VBLFlBQVksS0FBS1QsU0FBUyxJQUMxQixDQUNFVyxlQUFhLENBQUNJLHNCQUFzQixFQUNwQ0osZUFBYSxDQUFDSyxzQkFBc0IsQ0FDckMsQ0FBQ0UsUUFBUSxDQUFDVCxZQUFZLENBQUM7QUFFNUIifQ==