"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JSONLINES_LINK = exports.INVALID_DATASOURCE_MSG = exports.INSPECTOR_TAB_ID = exports.INSPECTOR_TABS = exports.INPUT_TRANSFORM_OPTIONS = exports.INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_NODE_API_PATH = exports.INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NAME_REGEXP = exports.IMAGE_FIELD_PATTERN = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = exports.GITHUB_FEEDBACK_LINK = exports.GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = exports.GET_SEARCH_TEMPLATES_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = exports.GET_AGENT_NODE_API_PATH = exports.GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = exports.FUZZY_QUERY_TEXT = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY = exports.EXPANDED_FORM_QUERY_ISSUE = exports.EXISTS_QUERY_TEXT = exports.EXAMPLE_PUT_AGENTIC_SEARCH_PIPELINE = exports.EXAMPLE_AGENTIC_SEARCH_QUERY = exports.ERROR_GETTING_WORKFLOW_MSG = exports.EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_FIELD_STRING = exports.EMPTY_AGENT = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DELIMITER_OPTIONAL_FIELDS = exports.DELETE_WORKFLOW_NODE_API_PATH = exports.DEFAULT_VECTOR_FIELD = exports.DEFAULT_TEXT_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_MCP_SERVER = exports.DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_K = exports.DEFAULT_IMAGE_FIELD = exports.DEFAULT_FETCH_SIZE = exports.DEFAULT_AGENT = exports.DEEPSEEK_CHAT_DOCS_LINK = exports.DATE_FORMAT_PATTERN = exports.CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_LINK = exports.CONNECTOR_PROTOCOL = exports.CONFIG_STEP = exports.COMPONENT_ID = exports.COMPONENT_CLASS = exports.COMPONENT_CATEGORY = exports.COHERE_EMBEDDING_MODEL_DOCS_LINK = exports.COHERE_CONFIGS = exports.CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CAT_INDICES_NODE_API_PATH = exports.BULK_NODE_API_PATH = exports.BULK_API_DOCS_LINK = exports.BEDROCK_TITAN_EMBEDDING_DOCS_LINK = exports.BEDROCK_CONFIGS = exports.BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = exports.BASE_WORKFLOW_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = exports.BASE_AGENT_NODE_API_PATH = exports.AGENT_TYPE = exports.AGENT_MEMORY_TYPE = exports.AGENT_MAIN_DOCS_LINK = exports.AGENT_LLM_INTERFACE_TYPE = exports.AGENT_ID_PATTERN = exports.AGENT_ID_PATH = exports.AGENT_FIELDS_DOCS_LINK = exports.AGENTIC_SEARCH_QUERY = exports.AGENTIC_SEARCH_MODELS_DOCS_LINK = exports.AGENTIC_SEARCH_MCP_DOCS_LINK = exports.AGENTIC_SEARCH_DOCS_LINK = exports.AGENTIC_SEARCH_AGENTS_DOCS_LINK = exports.AGENTIC_QUERY_DSL_DOCS_LINK = exports.ABORT_SEARCH_ERROR_MESSAGE = void 0;
exports.TEXT_FIELD_PATTERN = exports.TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_ALGORITHM = exports.TERM_QUERY_TEXT = exports.SOURCE_OPTIONS = exports.SORT_ORDER = exports.SIMULATE_PIPELINE_NODE_API_PATH = exports.SHARED_OPTIONAL_FIELDS = exports.SEMANTIC_SEARCH_TEMPLATE_QUERY = exports.SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_TEMPLATES_DOCS_LINK = exports.SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = exports.SEARCH_AGENTS_NODE_API_PATH = exports.SAGEMAKER_SPARSE_DEPLOY_LINK = exports.RESPONSE_FILTER_TYPE = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX = exports.REGISTER_AGENT_NODE_API_PATH = exports.QUERY_TEXT_PATTERN = exports.QUERY_STRING_QUERY_TEXT = exports.QUERY_PRESETS = exports.QUERY_PLANNING_TOOL_DOCS_LINK = exports.QUERY_PLANNING_MODEL_DOCS_LINK = exports.QUERY_IMAGE_PATTERN = exports.PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_TIMEOUT = exports.PROMPT_PRESETS = exports.PROCESSOR_TYPE = exports.PROCESSOR_CONTEXT = exports.PREFIX_QUERY_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OUTPUT_TRANSFORM_OPTIONS = exports.OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = exports.OPENAI_GPT35_DOCS_LINK = exports.OPENAI_CONFIGS = exports.OMIT_SYSTEM_INDEX_PATTERN = exports.NO_TRANSFORMATION = exports.NO_TEMPLATES_FOUND_MSG = exports.NO_MODIFICATIONS_FOUND_TEXT = exports.NORMALIZATION_PROCESSOR_LINK = exports.NODE_CATEGORY = exports.NEW_AGENT_PLACEHOLDER = exports.NEW_AGENT_ID_PLACEHOLDER = exports.NEURAL_SPARSE_SEARCH_QUERY = exports.NEURAL_SPARSE_CONFIGS = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = exports.MODEL_TYPE = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_ID_PATTERN = exports.MODEL_CATEGORY = exports.ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = exports.ML_SEARCH_AGENTS_ROUTE = exports.ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = exports.ML_REMOTE_MODEL_LINK = exports.ML_REGISTER_AGENT_ROUTE = exports.ML_MODEL_ROUTE_PREFIX = exports.ML_MODELS_SETUP_DOCS_LINK = exports.ML_INTERFACE_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = exports.ML_GET_AGENT_ROUTE = exports.ML_CONNECTOR_ROUTE_PREFIX = exports.ML_API_ROUTE_PREFIX = exports.ML_AGENT_ROUTE_PREFIX = exports.MIN_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = exports.MINIMUM_AGENTIC_SEARCH_VERSION = exports.MEMORY_DOCS_LINK = exports.MCP_CONNECTOR_DOCS_LINK = exports.MCP_AGENT_CONFIG_DOCS_LINK = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_TEMPLATE_STRING_LENGTH = exports.MAX_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = exports.MAX_DOCS_TO_IMPORT = exports.MAX_DOCS = exports.MAX_DESCRIPTION_LENGTH = exports.MAX_BYTES_FORMATTED = exports.MAX_BYTES = exports.MATCH_QUERY_TEXT = exports.MATCH_PHRASE_QUERY_TEXT = exports.MATCH_PHRASE_PREFIX_QUERY_TEXT = exports.MATCH_BOOLEAN_QUERY_TEXT = exports.MAIN_PLUGIN_DOC_LINK = exports.LEFT_NAV_SELECTED_STYLE = exports.LABEL_FIELD_PATTERN = exports.KNN_VECTOR_DOCS_LINK = exports.KNN_QUERY = exports.JSONPATH_ROOT_SELECTOR = exports.JSONPATH_DOCS_LINK = void 0;
exports.WORKFLOW_TYPE_LEGACY = exports.WORKFLOW_TYPE = exports.WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_REGEXP = exports.WILDCARD_QUERY_TEXT = exports.WEB_SEARCH_TOOL_DOCS_LINK = exports.VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_PATTERN = exports.VECTOR_FIELD_PATTERN = exports.VECTOR = exports.UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_MODEL_DOCS_LINK = exports.UPDATE_AGENT_NODE_API_PATH = exports.UI_METADATA_SCHEMA_VERSION = exports.TRANSFORM_TYPE = exports.TRANSFORM_CONTEXT = exports.TOOL_TYPE = exports.TOOL_DESCRIPTION = exports.TOOLS_DOCS_LINK = void 0;
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearch-flow';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'AI Search Flows'; // visible plugin name in the context of OSD

/**
 * BACKEND FLOW FRAMEWORK APIs
 */
const FLOW_FRAMEWORK_API_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_API_ROUTE_PREFIX = '/_plugins/_flow_framework';
const FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = exports.FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX = `${FLOW_FRAMEWORK_API_ROUTE_PREFIX}/workflow`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOWS_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/_search`;
const FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = exports.FLOW_FRAMEWORK_SEARCH_WORKFLOW_STATE_ROUTE = `${FLOW_FRAMEWORK_WORKFLOW_ROUTE_PREFIX}/state/_search`;

/**
 * BACKEND ML PLUGIN APIs
 */
const ML_API_ROUTE_PREFIX = exports.ML_API_ROUTE_PREFIX = '/_plugins/_ml';
const ML_MODEL_ROUTE_PREFIX = exports.ML_MODEL_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/models`;
const ML_CONNECTOR_ROUTE_PREFIX = exports.ML_CONNECTOR_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/connectors`;
const ML_AGENT_ROUTE_PREFIX = exports.ML_AGENT_ROUTE_PREFIX = `${ML_API_ROUTE_PREFIX}/agents`;
const ML_SEARCH_MODELS_ROUTE = exports.ML_SEARCH_MODELS_ROUTE = `${ML_MODEL_ROUTE_PREFIX}/_search`;
const ML_SEARCH_CONNECTORS_ROUTE = exports.ML_SEARCH_CONNECTORS_ROUTE = `${ML_CONNECTOR_ROUTE_PREFIX}/_search`;
const ML_REGISTER_AGENT_ROUTE = exports.ML_REGISTER_AGENT_ROUTE = `${ML_AGENT_ROUTE_PREFIX}/_register`;
const ML_SEARCH_AGENTS_ROUTE = exports.ML_SEARCH_AGENTS_ROUTE = `${ML_AGENT_ROUTE_PREFIX}/_search`;
const ML_GET_AGENT_ROUTE = exports.ML_GET_AGENT_ROUTE = `${ML_AGENT_ROUTE_PREFIX}/{agentId}`;

/**
 * OpenSearch APIs
 */
const SEARCH_PIPELINE_ROUTE = exports.SEARCH_PIPELINE_ROUTE = '/_search/pipeline';

/**
 * NODE APIs
 */
const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/flow_framework';

// OpenSearch node APIs
const BASE_OPENSEARCH_NODE_API_PATH = exports.BASE_OPENSEARCH_NODE_API_PATH = `${BASE_NODE_API_PATH}/opensearch`;
const CAT_INDICES_NODE_API_PATH = exports.CAT_INDICES_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/catIndices`;
const GET_MAPPINGS_NODE_API_PATH = exports.GET_MAPPINGS_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/mappings`;
const GET_INDEX_NODE_API_PATH = exports.GET_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIndex`;
const SEARCH_INDEX_NODE_API_PATH = exports.SEARCH_INDEX_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/search`;
const INGEST_NODE_API_PATH = exports.INGEST_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/ingest`;
const BULK_NODE_API_PATH = exports.BULK_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/bulk`;
const SIMULATE_PIPELINE_NODE_API_PATH = exports.SIMULATE_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/simulatePipeline`;
const INGEST_PIPELINE_NODE_API_PATH = exports.INGEST_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getIngestPipeline`;
const SEARCH_PIPELINE_NODE_API_PATH = exports.SEARCH_PIPELINE_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getSearchPipeline`;
const GET_SEARCH_TEMPLATES_NODE_API_PATH = exports.GET_SEARCH_TEMPLATES_NODE_API_PATH = `${BASE_OPENSEARCH_NODE_API_PATH}/getSearchTemplates`;

// Flow Framework node APIs
const BASE_WORKFLOW_NODE_API_PATH = exports.BASE_WORKFLOW_NODE_API_PATH = `${BASE_NODE_API_PATH}/workflow`;
const GET_WORKFLOW_NODE_API_PATH = exports.GET_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}`;
const SEARCH_WORKFLOWS_NODE_API_PATH = exports.SEARCH_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/search`;
const GET_WORKFLOW_STATE_NODE_API_PATH = exports.GET_WORKFLOW_STATE_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/state`;
const CREATE_WORKFLOW_NODE_API_PATH = exports.CREATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/create`;
const UPDATE_WORKFLOW_NODE_API_PATH = exports.UPDATE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/update`;
const PROVISION_WORKFLOW_NODE_API_PATH = exports.PROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/provision`;
const DEPROVISION_WORKFLOW_NODE_API_PATH = exports.DEPROVISION_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/deprovision`;
const DELETE_WORKFLOW_NODE_API_PATH = exports.DELETE_WORKFLOW_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/delete`;
const GET_PRESET_WORKFLOWS_NODE_API_PATH = exports.GET_PRESET_WORKFLOWS_NODE_API_PATH = `${BASE_WORKFLOW_NODE_API_PATH}/presets`;

// ML Plugin node APIs
const BASE_MODEL_NODE_API_PATH = exports.BASE_MODEL_NODE_API_PATH = `${BASE_NODE_API_PATH}/model`;
const BASE_CONNECTOR_NODE_API_PATH = exports.BASE_CONNECTOR_NODE_API_PATH = `${BASE_NODE_API_PATH}/connector`;
const BASE_AGENT_NODE_API_PATH = exports.BASE_AGENT_NODE_API_PATH = `${BASE_NODE_API_PATH}/agent`;
const SEARCH_MODELS_NODE_API_PATH = exports.SEARCH_MODELS_NODE_API_PATH = `${BASE_MODEL_NODE_API_PATH}/search`;
const SEARCH_CONNECTORS_NODE_API_PATH = exports.SEARCH_CONNECTORS_NODE_API_PATH = `${BASE_CONNECTOR_NODE_API_PATH}/search`;
const REGISTER_AGENT_NODE_API_PATH = exports.REGISTER_AGENT_NODE_API_PATH = `${BASE_AGENT_NODE_API_PATH}/register`;
const UPDATE_AGENT_NODE_API_PATH = exports.UPDATE_AGENT_NODE_API_PATH = `${BASE_AGENT_NODE_API_PATH}/update`;
const SEARCH_AGENTS_NODE_API_PATH = exports.SEARCH_AGENTS_NODE_API_PATH = `${BASE_AGENT_NODE_API_PATH}/search`;
const GET_AGENT_NODE_API_PATH = exports.GET_AGENT_NODE_API_PATH = `${BASE_AGENT_NODE_API_PATH}`;

/**
 * Remote model dimensions. Used for attempting to pre-fill dimension size
 * based on the specified remote model from a remote service, if found
 */

// Amazon BedRock
const BEDROCK_CONFIGS = exports.BEDROCK_CONFIGS = {
  [`amazon.titan-embed-text-v1`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-text-v2`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`amazon.titan-embed-image-v1`]: {
    dimension: 1024,
    fieldName: 'embedding'
  },
  [`cohere.embed-english-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`cohere.embed-multilingual-v3`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  }
};

// Cohere
const COHERE_CONFIGS = exports.COHERE_CONFIGS = {
  [`embed-english-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v3.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-light-v3.0`]: {
    dimension: 384,
    fieldName: 'embeddings'
  },
  [`embed-english-v2.0`]: {
    dimension: 4096,
    fieldName: 'embeddings'
  },
  [`embed-english-light-v2.0`]: {
    dimension: 1024,
    fieldName: 'embeddings'
  },
  [`embed-multilingual-v2.0`]: {
    dimension: 768,
    fieldName: 'embeddings'
  }
};

// OpenAI
const OPENAI_CONFIGS = exports.OPENAI_CONFIGS = {
  [`text-embedding-3-small`]: {
    dimension: 1536,
    fieldName: 'embedding'
  },
  [`text-embedding-3-large`]: {
    dimension: 3072,
    fieldName: 'embedding'
  },
  [`text-embedding-ada-002`]: {
    dimension: 1536,
    fieldName: 'embedding'
  }
};

// Neural Sparse
const NEURAL_SPARSE_CONFIGS = exports.NEURAL_SPARSE_CONFIGS = {
  [`opensearch-neural-sparse-encoding-v2-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-v1`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-multilingual-v1`]: {
    dimension: 105879,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v2-mini`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v3-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v1`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  },
  [`opensearch-neural-sparse-encoding-doc-v2-distill`]: {
    dimension: 30522,
    fieldName: 'passage_embedding'
  }
};

/**
 * Various constants pertaining to Workflow configs
 */

/**
 * Schema versioning for tracking all changes made to the config fields within ui_metadata. Used for BWC and debugging.
 * Version 1: Initial release
 * Version 2: Updates ML search response processor to have an additional "ext_output" field. https://github.com/opensearch-project/dashboards-flow-framework/pull/699
 */
const UI_METADATA_SCHEMA_VERSION = exports.UI_METADATA_SCHEMA_VERSION = 2;

// frontend-specific workflow types, derived from the available preset templates
let WORKFLOW_TYPE = exports.WORKFLOW_TYPE = /*#__PURE__*/function (WORKFLOW_TYPE) {
  WORKFLOW_TYPE["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE["VECTOR_SEARCH_WITH_RAG"] = "RAG with Vector Retrieval";
  WORKFLOW_TYPE["HYBRID_SEARCH_WITH_RAG"] = "RAG with Hybrid Search";
  WORKFLOW_TYPE["SEMANTIC_SEARCH_USING_SPARSE_ENCODERS"] = "Semantic Search using Sparse Encoders";
  WORKFLOW_TYPE["AGENTIC_SEARCH"] = "Agentic Search";
  WORKFLOW_TYPE["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE;
}({});
let WORKFLOW_TYPE_LEGACY = exports.WORKFLOW_TYPE_LEGACY = /*#__PURE__*/function (WORKFLOW_TYPE_LEGACY) {
  WORKFLOW_TYPE_LEGACY["SEMANTIC_SEARCH"] = "Semantic Search";
  WORKFLOW_TYPE_LEGACY["MULTIMODAL_SEARCH"] = "Multimodal Search";
  WORKFLOW_TYPE_LEGACY["HYBRID_SEARCH"] = "Hybrid Search";
  WORKFLOW_TYPE_LEGACY["CUSTOM"] = "Custom Search";
  WORKFLOW_TYPE_LEGACY["UNKNOWN"] = "Unknown";
  return WORKFLOW_TYPE_LEGACY;
}({}); // If no datasource version is found, we default to 2.17.0
const MIN_SUPPORTED_VERSION = exports.MIN_SUPPORTED_VERSION = '2.17.0';
// Min version to support ML processors
const MINIMUM_FULL_SUPPORTED_VERSION = exports.MINIMUM_FULL_SUPPORTED_VERSION = '2.19.0';
// Min version to support agentic search
const MINIMUM_AGENTIC_SEARCH_VERSION = exports.MINIMUM_AGENTIC_SEARCH_VERSION = '3.3.0';

// the names should be consistent with the underlying implementation. used when generating the
// final ingest/search pipeline configurations.
let PROCESSOR_TYPE = exports.PROCESSOR_TYPE = /*#__PURE__*/function (PROCESSOR_TYPE) {
  PROCESSOR_TYPE["ML"] = "ml_inference";
  PROCESSOR_TYPE["SPLIT"] = "split";
  PROCESSOR_TYPE["SORT"] = "sort";
  PROCESSOR_TYPE["TEXT_CHUNKING"] = "text_chunking";
  PROCESSOR_TYPE["NORMALIZATION"] = "normalization-processor";
  PROCESSOR_TYPE["COLLAPSE"] = "collapse";
  PROCESSOR_TYPE["RERANK"] = "rerank";
  PROCESSOR_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  PROCESSOR_TYPE["TEXT_IMAGE_EMBEDDING"] = "text_image_embedding";
  PROCESSOR_TYPE["COPY"] = "copy";
  PROCESSOR_TYPE["AGENTIC_QUERY_TRANSLATOR"] = "agentic_query_translator";
  PROCESSOR_TYPE["AGENTIC_CONTEXT"] = "agentic_context";
  return PROCESSOR_TYPE;
}({});
let MODEL_TYPE = exports.MODEL_TYPE = /*#__PURE__*/function (MODEL_TYPE) {
  MODEL_TYPE["TEXT_EMBEDDING"] = "text_embedding";
  MODEL_TYPE["SPARSE_ENCODER"] = "sparse_encoder";
  return MODEL_TYPE;
}({});
let MODEL_CATEGORY = exports.MODEL_CATEGORY = /*#__PURE__*/function (MODEL_CATEGORY) {
  MODEL_CATEGORY["EMBEDDING"] = "EMBEDDING";
  MODEL_CATEGORY["LLM"] = "LLM";
  MODEL_CATEGORY["SPARSE_ENCODER"] = "SPARSE_ENCODER";
  return MODEL_CATEGORY;
}({});
/**
 * Various constants pertaining to the drag-and-drop UI components
 */
let COMPONENT_CATEGORY = exports.COMPONENT_CATEGORY = /*#__PURE__*/function (COMPONENT_CATEGORY) {
  COMPONENT_CATEGORY["INGEST"] = "Ingest";
  COMPONENT_CATEGORY["SEARCH"] = "Search";
  return COMPONENT_CATEGORY;
}({});
let NODE_CATEGORY = exports.NODE_CATEGORY = /*#__PURE__*/function (NODE_CATEGORY) {
  NODE_CATEGORY["CUSTOM"] = "custom";
  NODE_CATEGORY["INGEST_GROUP"] = "ingestGroup";
  NODE_CATEGORY["SEARCH_GROUP"] = "searchGroup";
  return NODE_CATEGORY;
}({});
/**
 * A base set of component classes / types.
 */
let COMPONENT_CLASS = exports.COMPONENT_CLASS = /*#__PURE__*/function (COMPONENT_CLASS) {
  COMPONENT_CLASS["INDEX"] = "index";
  COMPONENT_CLASS["KNN_INDEX"] = "knn_index";
  COMPONENT_CLASS["TRANSFORMER"] = "transformer";
  COMPONENT_CLASS["ML_TRANSFORMER"] = "ml_transformer";
  COMPONENT_CLASS["SEARCH_REQUEST"] = "search_request";
  COMPONENT_CLASS["DOCUMENT"] = "document";
  COMPONENT_CLASS["SEARCH_RESPONSE"] = "search_response";
  return COMPONENT_CLASS;
}({});
/**
 * LINKS
 */
const ML_INFERENCE_DOCS_LINK = exports.ML_INFERENCE_DOCS_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/ml-inference/#configuration-parameters';
const ML_INFERENCE_RESPONSE_DOCS_LINK = exports.ML_INFERENCE_RESPONSE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#request-fields';
const ML_REMOTE_MODEL_LINK = exports.ML_REMOTE_MODEL_LINK = 'https://docs.opensearch.org/docs/latest/ml-commons-plugin/remote-models/supported-connectors/';
const ML_INTERFACE_LINK = exports.ML_INTERFACE_LINK = 'https://docs.opensearch.org/docs/latest/ml-commons-plugin/api/model-apis/register-model/#the-interface-parameter';
const TEXT_CHUNKING_PROCESSOR_LINK = exports.TEXT_CHUNKING_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/ingest-pipelines/processors/text-chunking/';
const CREATE_WORKFLOW_LINK = exports.CREATE_WORKFLOW_LINK = 'https://opensearch.org/docs/latest/automating-configurations/api/create-workflow/';
const WORKFLOW_TUTORIAL_LINK = exports.WORKFLOW_TUTORIAL_LINK = 'https://opensearch.org/docs/latest/automating-configurations/workflow-tutorial/';
const MAIN_PLUGIN_DOC_LINK = exports.MAIN_PLUGIN_DOC_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/workflow-builder/';
const NORMALIZATION_PROCESSOR_LINK = exports.NORMALIZATION_PROCESSOR_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/normalization-processor/';
const GITHUB_FEEDBACK_LINK = exports.GITHUB_FEEDBACK_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/issues/new/choose';
const JSONPATH_DOCS_LINK = exports.JSONPATH_DOCS_LINK = 'https://www.npmjs.com/package/jsonpath-plus';
const KNN_VECTOR_DOCS_LINK = exports.KNN_VECTOR_DOCS_LINK = 'https://opensearch.org/docs/latest/field-types/supported-field-types/knn-vector/';
const BULK_API_DOCS_LINK = exports.BULK_API_DOCS_LINK = 'https://opensearch.org/docs/latest/api-reference/document-apis/bulk/';
const SEARCH_PIPELINE_DOCS_LINK = exports.SEARCH_PIPELINE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/using-search-pipeline/';
const ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = exports.ML_RESPONSE_PROCESSOR_EXAMPLE_DOCS_LINK = 'https://opensearch.org/docs/latest/search-plugins/search-pipelines/ml-inference-search-response/#example-externally-hosted-text-embedding-model';
const UPDATE_MODEL_DOCS_LINK = exports.UPDATE_MODEL_DOCS_LINK = 'https://opensearch.org/docs/latest/ml-commons-plugin/api/model-apis/update-model/';
const JSONLINES_LINK = exports.JSONLINES_LINK = 'https://jsonlines.org/';
const EXPANDED_FORM_QUERY_ISSUE = exports.EXPANDED_FORM_QUERY_ISSUE = 'https://github.com/opensearch-project/OpenSearch/issues/17358';
const AGENT_MAIN_DOCS_LINK = exports.AGENT_MAIN_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/agents/index/';
const AGENTIC_SEARCH_DOCS_LINK = exports.AGENTIC_SEARCH_DOCS_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/agentic-search/';
const AGENTIC_SEARCH_MODELS_DOCS_LINK = exports.AGENTIC_SEARCH_MODELS_DOCS_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/agentic-search/agent-customization/#model-configuration';
const AGENTIC_SEARCH_AGENTS_DOCS_LINK = exports.AGENTIC_SEARCH_AGENTS_DOCS_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/agentic-search/agent-customization/';
const AGENTIC_SEARCH_MCP_DOCS_LINK = exports.AGENTIC_SEARCH_MCP_DOCS_LINK = 'https://docs.opensearch.org/latest/vector-search/ai-search/agentic-search/mcp-server/';
const AGENTIC_QUERY_DSL_DOCS_LINK = exports.AGENTIC_QUERY_DSL_DOCS_LINK = 'https://docs.opensearch.org/latest/query-dsl/specialized/agentic/';
const MCP_CONNECTOR_DOCS_LINK = exports.MCP_CONNECTOR_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/mcp/mcp-connector';
const MCP_AGENT_CONFIG_DOCS_LINK = exports.MCP_AGENT_CONFIG_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/mcp/mcp-connector#step-3-register-an-agent-for-accessing-mcp-tools';
const AGENT_FIELDS_DOCS_LINK = exports.AGENT_FIELDS_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/api/agent-apis/register-agent/#request-body-fields';
const TOOLS_DOCS_LINK = exports.TOOLS_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/index/';
const MEMORY_DOCS_LINK = exports.MEMORY_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/api/memory-apis/index/';
const QUERY_PLANNING_TOOL_DOCS_LINK = exports.QUERY_PLANNING_TOOL_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/query-planning-tool#register-parameters';
const QUERY_PLANNING_MODEL_DOCS_LINK = exports.QUERY_PLANNING_MODEL_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/query-planning-tool/#step-2-register-and-deploy-a-model';
const WEB_SEARCH_TOOL_DOCS_LINK = exports.WEB_SEARCH_TOOL_DOCS_LINK = 'https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/web-search-tool/#register-parameters';
const SEARCH_TEMPLATES_DOCS_LINK = exports.SEARCH_TEMPLATES_DOCS_LINK = 'https://docs.opensearch.org/latest/api-reference/search-apis/search-template/index/';

// Large Language Models Documentation Links
const BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = exports.BEDROCK_CLAUDE_3_SONNET_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#claude-3-sonnet-hosted-on-amazon-bedrock';
const OPENAI_GPT35_DOCS_LINK = exports.OPENAI_GPT35_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#openai-gpt-35';
const DEEPSEEK_CHAT_DOCS_LINK = exports.DEEPSEEK_CHAT_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#deepseek-chat';

// Embedding Models Documentation Links
const COHERE_EMBEDDING_MODEL_DOCS_LINK = exports.COHERE_EMBEDDING_MODEL_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#cohere-embed';
const BEDROCK_TITAN_EMBEDDING_DOCS_LINK = exports.BEDROCK_TITAN_EMBEDDING_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md#amazon-bedrock-titan-text-embedding';

// Sparse Encoder Models Documentation Links
const OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = exports.OPENSEARCH_NEURAL_SPARSE_DOCS_LINK = 'https://huggingface.co/opensearch-project/opensearch-neural-sparse-encoding-v2-distill';

// TODO: Update this with the official OpenSearch documentation URL when it's available
const SAGEMAKER_SPARSE_DEPLOY_LINK = exports.SAGEMAKER_SPARSE_DEPLOY_LINK = 'https://github.com/zhichao-aws/opensearch-neural-sparse-sample/tree/main/examples/deploy_on_sagemaker';

// ML Models setup Documentation Link
const ML_MODELS_SETUP_DOCS_LINK = exports.ML_MODELS_SETUP_DOCS_LINK = 'https://github.com/opensearch-project/dashboards-flow-framework/blob/main/documentation/models.md';

/**
 * Text chunking algorithm constants
 */
let TEXT_CHUNKING_ALGORITHM = exports.TEXT_CHUNKING_ALGORITHM = /*#__PURE__*/function (TEXT_CHUNKING_ALGORITHM) {
  TEXT_CHUNKING_ALGORITHM["FIXED_TOKEN_LENGTH"] = "fixed_token_length";
  TEXT_CHUNKING_ALGORITHM["DELIMITER"] = "delimiter";
  return TEXT_CHUNKING_ALGORITHM;
}({});
const FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = exports.FIXED_TOKEN_LENGTH_OPTIONAL_FIELDS = ['token_limit', 'tokenizer', 'overlap_rate'];
const DELIMITER_OPTIONAL_FIELDS = exports.DELIMITER_OPTIONAL_FIELDS = ['delimiter'];
const SHARED_OPTIONAL_FIELDS = exports.SHARED_OPTIONAL_FIELDS = ['max_chunk_limit', 'description', 'tag'];

/**
 * DEFAULT FIELD VALUES
 */
const DEFAULT_TEXT_FIELD = exports.DEFAULT_TEXT_FIELD = 'my_text';
const DEFAULT_VECTOR_FIELD = exports.DEFAULT_VECTOR_FIELD = 'my_embedding';
const DEFAULT_IMAGE_FIELD = exports.DEFAULT_IMAGE_FIELD = 'my_image';
const DEFAULT_LLM_RESPONSE_FIELD = exports.DEFAULT_LLM_RESPONSE_FIELD = 'llm_response';

/**
 * QUERY PRESETS
 */
const VECTOR_FIELD_PATTERN = exports.VECTOR_FIELD_PATTERN = `{{vector_field}}`;
const TEXT_FIELD_PATTERN = exports.TEXT_FIELD_PATTERN = `{{text_field}}`;
const IMAGE_FIELD_PATTERN = exports.IMAGE_FIELD_PATTERN = `{{image_field}}`;
const LABEL_FIELD_PATTERN = exports.LABEL_FIELD_PATTERN = `{{label_field}}`;
const QUERY_TEXT_PATTERN = exports.QUERY_TEXT_PATTERN = `{{query_text}}`;
const QUERY_IMAGE_PATTERN = exports.QUERY_IMAGE_PATTERN = `{{query_image}}`;
const MODEL_ID_PATTERN = exports.MODEL_ID_PATTERN = `{{model_id}}`;
const AGENT_ID_PATTERN = exports.AGENT_ID_PATTERN = `{{agent_id}}`;
const VECTOR = exports.VECTOR = 'vector';
const VECTOR_PATTERN = exports.VECTOR_PATTERN = `{{${VECTOR}}}`;
const VECTOR_TEMPLATE_PLACEHOLDER = exports.VECTOR_TEMPLATE_PLACEHOLDER = `\$\{${VECTOR}\}`;
const DEFAULT_K = exports.DEFAULT_K = 10;
const DEFAULT_FETCH_SIZE = exports.DEFAULT_FETCH_SIZE = 10;

// term-level queries
const TERM_QUERY_TEXT = exports.TERM_QUERY_TEXT = {
  query: {
    term: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const EXISTS_QUERY_TEXT = exports.EXISTS_QUERY_TEXT = {
  query: {
    exists: {
      field: TEXT_FIELD_PATTERN
    }
  }
};
const FUZZY_QUERY_TEXT = exports.FUZZY_QUERY_TEXT = {
  query: {
    fuzzy: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
const WILDCARD_QUERY_TEXT = exports.WILDCARD_QUERY_TEXT = {
  query: {
    wildcard: {
      [TEXT_FIELD_PATTERN]: {
        wildcard: QUERY_TEXT_PATTERN,
        case_insensitive: false
      }
    }
  }
};
const PREFIX_QUERY_TEXT = exports.PREFIX_QUERY_TEXT = {
  query: {
    prefix: {
      [TEXT_FIELD_PATTERN]: {
        value: QUERY_TEXT_PATTERN
      }
    }
  }
};
// full-text queries
const MATCH_QUERY_TEXT = exports.MATCH_QUERY_TEXT = {
  query: {
    match: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_BOOLEAN_QUERY_TEXT = exports.MATCH_BOOLEAN_QUERY_TEXT = {
  query: {
    match_bool_prefix: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_PHRASE_QUERY_TEXT = exports.MATCH_PHRASE_QUERY_TEXT = {
  query: {
    match_phrase: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const MATCH_PHRASE_PREFIX_QUERY_TEXT = exports.MATCH_PHRASE_PREFIX_QUERY_TEXT = {
  query: {
    match_phrase_prefix: {
      [TEXT_FIELD_PATTERN]: {
        query: QUERY_TEXT_PATTERN
      }
    }
  }
};
const QUERY_STRING_QUERY_TEXT = exports.QUERY_STRING_QUERY_TEXT = {
  query: {
    query_string: {
      query: QUERY_TEXT_PATTERN
    }
  }
};
// misc / other queries
const FETCH_ALL_QUERY = exports.FETCH_ALL_QUERY = {
  query: {
    match_all: {}
  },
  size: DEFAULT_FETCH_SIZE
};
const FETCH_ALL_QUERY_LARGE = exports.FETCH_ALL_QUERY_LARGE = {
  query: {
    match_all: {}
  },
  size: 1000
};
const KNN_QUERY = exports.KNN_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    knn: {
      [VECTOR_FIELD_PATTERN]: {
        vector: VECTOR_PATTERN,
        k: DEFAULT_K
      }
    }
  },
  size: 10
};
const SEMANTIC_SEARCH_QUERY_NEURAL = exports.SEMANTIC_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const SEMANTIC_SEARCH_TEMPLATE_QUERY = exports.SEMANTIC_SEARCH_TEMPLATE_QUERY = {
  query: {
    template: {
      knn: {
        [VECTOR_FIELD_PATTERN]: {
          vector: VECTOR_PATTERN,
          k: 2
        }
      }
    }
  },
  ext: {
    ml_inference: {
      text: QUERY_TEXT_PATTERN
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_NEURAL = exports.MULTIMODAL_SEARCH_QUERY_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural: {
      [VECTOR_FIELD_PATTERN]: {
        query_text: QUERY_TEXT_PATTERN,
        query_image: QUERY_IMAGE_PATTERN,
        model_id: MODEL_ID_PATTERN,
        k: DEFAULT_K
      }
    }
  }
};
const MULTIMODAL_SEARCH_QUERY_BOOL = exports.MULTIMODAL_SEARCH_QUERY_BOOL = {
  query: {
    bool: {
      must: [{
        match: {
          [TEXT_FIELD_PATTERN]: QUERY_TEXT_PATTERN
        }
      }, {
        match: {
          [IMAGE_FIELD_PATTERN]: QUERY_IMAGE_PATTERN
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_KNN = exports.HYBRID_SEARCH_QUERY_MATCH_KNN = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        knn: {
          [VECTOR_FIELD_PATTERN]: {
            vector: VECTOR_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_NEURAL = exports.HYBRID_SEARCH_QUERY_MATCH_NEURAL = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        neural: {
          [VECTOR_FIELD_PATTERN]: {
            query_text: QUERY_TEXT_PATTERN,
            model_id: MODEL_ID_PATTERN,
            k: DEFAULT_K
          }
        }
      }]
    }
  }
};
const HYBRID_SEARCH_QUERY_MATCH_TERM = exports.HYBRID_SEARCH_QUERY_MATCH_TERM = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    hybrid: {
      queries: [{
        match: {
          [TEXT_FIELD_PATTERN]: {
            query: QUERY_TEXT_PATTERN
          }
        }
      }, {
        term: {
          [TEXT_FIELD_PATTERN]: {
            value: QUERY_TEXT_PATTERN
          }
        }
      }]
    }
  }
};
const NEURAL_SPARSE_SEARCH_QUERY = exports.NEURAL_SPARSE_SEARCH_QUERY = {
  _source: {
    excludes: [VECTOR_FIELD_PATTERN]
  },
  query: {
    neural_sparse: {
      [VECTOR_FIELD_PATTERN]: {
        query_tokens: VECTOR_PATTERN
      }
    }
  }
};
const AGENTIC_SEARCH_QUERY = exports.AGENTIC_SEARCH_QUERY = {
  query: {
    agentic: {
      query_text: '',
      query_fields: []
    }
  }
};
const QUERY_PRESETS = exports.QUERY_PRESETS = [{
  name: 'Fetch all',
  query: (0, _utils.customStringify)(FETCH_ALL_QUERY)
}, {
  name: 'Term',
  query: (0, _utils.customStringify)(TERM_QUERY_TEXT)
}, {
  name: 'Match',
  query: (0, _utils.customStringify)(MATCH_QUERY_TEXT)
}, {
  name: 'Exists',
  query: (0, _utils.customStringify)(EXISTS_QUERY_TEXT)
}, {
  name: 'Fuzzy',
  query: (0, _utils.customStringify)(FUZZY_QUERY_TEXT)
}, {
  name: 'Wildcard',
  query: (0, _utils.customStringify)(WILDCARD_QUERY_TEXT)
}, {
  name: 'Prefix',
  query: (0, _utils.customStringify)(PREFIX_QUERY_TEXT)
}, {
  name: 'Match boolean',
  query: (0, _utils.customStringify)(MATCH_BOOLEAN_QUERY_TEXT)
}, {
  name: 'Match phrase',
  query: (0, _utils.customStringify)(MATCH_PHRASE_QUERY_TEXT)
}, {
  name: 'Match phrase prefix',
  query: (0, _utils.customStringify)(MATCH_PHRASE_PREFIX_QUERY_TEXT)
}, {
  name: 'Query string',
  query: (0, _utils.customStringify)(QUERY_STRING_QUERY_TEXT)
}, {
  name: 'Basic k-NN',
  query: (0, _utils.customStringify)(KNN_QUERY)
}, {
  name: WORKFLOW_TYPE.MULTIMODAL_SEARCH,
  query: (0, _utils.customStringify)(MULTIMODAL_SEARCH_QUERY_BOOL)
}, {
  name: 'Neural Sparse Search Query',
  query: (0, _utils.customStringify)(NEURAL_SPARSE_SEARCH_QUERY)
}, {
  name: 'Semantic search (neural query)',
  query: (0, _utils.customStringify)(SEMANTIC_SEARCH_QUERY_NEURAL)
}, {
  name: 'Semantic search (template query)',
  query: (0, _utils.customStringify)(SEMANTIC_SEARCH_TEMPLATE_QUERY)
}, {
  name: `Hybrid search (match & k-NN queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_KNN)
}, {
  name: `Hybrid search (match & term queries)`,
  query: (0, _utils.customStringify)(HYBRID_SEARCH_QUERY_MATCH_TERM)
}, {
  name: 'Agentic search',
  query: (0, _utils.customStringify)(AGENTIC_SEARCH_QUERY)
}];

/**
 * DEFAULT TEMPLATE VAR NAMES
 */
const DEFAULT_PROMPT_RESULTS_FIELD = exports.DEFAULT_PROMPT_RESULTS_FIELD = 'results';
const DEFAULT_PROMPT_QUESTION_FIELD = exports.DEFAULT_PROMPT_QUESTION_FIELD = 'question';
const DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = exports.DEFAULT_PROMPT_TEXT_CATEGORY_FIELD = 'textCategory';
const DEFAULT_PROMPT_ROLE_FIELD = exports.DEFAULT_PROMPT_ROLE_FIELD = 'role';

/**
 * PROMPT PRESETS. Based off of https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-templates-and-examples.html
 */
const GENERAL_SUMMARIZE_PROMPT = exports.GENERAL_SUMMARIZE_PROMPT = 'Read the following text: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\nSummarize the text in one sentence.';
const GENERAL_QA_WITH_CONTEXT_PROMPT = exports.GENERAL_QA_WITH_CONTEXT_PROMPT = 'Read the following text, and answer the question at the end: \
\n\n${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()} \
\n\n${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_QA_NO_CONTEXT_PROMPT = exports.GENERAL_QA_NO_CONTEXT_PROMPT = 'Answer the following question: \
${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}';
const GENERAL_TEXT_GENERATION_PROMPT = exports.GENERAL_TEXT_GENERATION_PROMPT = 'Please write a ${parameters.' + DEFAULT_PROMPT_TEXT_CATEGORY_FIELD + '.toString()} in the voice of ${parameters.' + DEFAULT_PROMPT_ROLE_FIELD + '.toString()}';
const CLAUDE_SUMMARIZE_PROMPT = exports.CLAUDE_SUMMARIZE_PROMPT = 'Human: read the following results inside the <text></text> XML tags:\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + ".toString()}\n</text>\n\n\
Summarize the above results in one sentence. If you don't know the answer, just \
say I don't know.\
\n\nAssistant:";
const CLAUDE_QA_WITH_CONTEXT_PROMPT = exports.CLAUDE_QA_WITH_CONTEXT_PROMPT = 'Human: read the following results inside the <text></text> XML tags, and then answer the question:\
\n\n<text>\n\
${parameters.' + DEFAULT_PROMPT_RESULTS_FIELD + '.toString()}\n\
</text>\n\n' + '${parameters.' + DEFAULT_PROMPT_QUESTION_FIELD + '.toString()}\n\nAssistant:';
const PROMPT_PRESETS = exports.PROMPT_PRESETS = [{
  name: 'Summarize text',
  prompt: GENERAL_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context',
  prompt: GENERAL_QA_WITH_CONTEXT_PROMPT
}, {
  name: 'Question-answer, without context',
  prompt: GENERAL_QA_NO_CONTEXT_PROMPT
}, {
  name: 'Text generation',
  prompt: GENERAL_TEXT_GENERATION_PROMPT
}, {
  name: 'Summarize text (Claude)',
  prompt: CLAUDE_SUMMARIZE_PROMPT
}, {
  name: 'Question-answer, with context (Claude)',
  prompt: CLAUDE_QA_WITH_CONTEXT_PROMPT
}];

/**
 * MISCELLANEOUS
 */
let PROCESSOR_CONTEXT = exports.PROCESSOR_CONTEXT = /*#__PURE__*/function (PROCESSOR_CONTEXT) {
  PROCESSOR_CONTEXT["INGEST"] = "ingest";
  PROCESSOR_CONTEXT["SEARCH_REQUEST"] = "search_request";
  PROCESSOR_CONTEXT["SEARCH_RESPONSE"] = "search_response";
  return PROCESSOR_CONTEXT;
}({});
const NO_TRANSFORMATION = exports.NO_TRANSFORMATION = 'No transformation';
let TRANSFORM_CONTEXT = exports.TRANSFORM_CONTEXT = /*#__PURE__*/function (TRANSFORM_CONTEXT) {
  TRANSFORM_CONTEXT["INPUT"] = "input";
  TRANSFORM_CONTEXT["OUTPUT"] = "output";
  return TRANSFORM_CONTEXT;
}({});
let TRANSFORM_TYPE = exports.TRANSFORM_TYPE = /*#__PURE__*/function (TRANSFORM_TYPE) {
  TRANSFORM_TYPE["STRING"] = "Custom string";
  TRANSFORM_TYPE["FIELD"] = "Data field";
  TRANSFORM_TYPE["EXPRESSION"] = "JSONPath expression";
  TRANSFORM_TYPE["TEMPLATE"] = "Prompt";
  return TRANSFORM_TYPE;
}({});
const INPUT_TRANSFORM_OPTIONS = exports.INPUT_TRANSFORM_OPTIONS = [{
  id: TRANSFORM_TYPE.FIELD,
  description: 'Use an existing field from your data as the model input field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to the model input field.'
}, {
  id: TRANSFORM_TYPE.TEMPLATE,
  description: 'Configure a prompt to map data to the model input field.'
}, {
  id: TRANSFORM_TYPE.STRING,
  description: 'Use a custom string in the model input field.'
}];
const OUTPUT_TRANSFORM_OPTIONS = exports.OUTPUT_TRANSFORM_OPTIONS = [{
  id: NO_TRANSFORMATION,
  description: ''
}, {
  id: TRANSFORM_TYPE.FIELD,
  description: 'Copy the model output into a new document field.'
}, {
  id: TRANSFORM_TYPE.EXPRESSION,
  description: 'Extract data from a JSON structure and map the extracted data to a new document field.'
}];
const ABORT_SEARCH_ERROR_MESSAGE = exports.ABORT_SEARCH_ERROR_MESSAGE = 'Error searching index: signal is aborted without reason';
const DEFAULT_NEW_WORKFLOW_NAME = exports.DEFAULT_NEW_WORKFLOW_NAME = 'new_workflow';
const DEFAULT_NEW_WORKFLOW_DESCRIPTION = exports.DEFAULT_NEW_WORKFLOW_DESCRIPTION = 'My new workflow';
const DEFAULT_NEW_WORKFLOW_STATE_TYPE = exports.DEFAULT_NEW_WORKFLOW_STATE_TYPE = 'NOT_STARTED';
const DATE_FORMAT_PATTERN = exports.DATE_FORMAT_PATTERN = 'MM/DD/YY hh:mm A';
const EMPTY_FIELD_STRING = exports.EMPTY_FIELD_STRING = '--';
const OMIT_SYSTEM_INDEX_PATTERN = exports.OMIT_SYSTEM_INDEX_PATTERN = '*,-.*';
const INDEX_NOT_FOUND_EXCEPTION = exports.INDEX_NOT_FOUND_EXCEPTION = 'index_not_found_exception';
const ERROR_GETTING_WORKFLOW_MSG = exports.ERROR_GETTING_WORKFLOW_MSG = 'Failed to retrieve template';
const INVALID_DATASOURCE_MSG = exports.INVALID_DATASOURCE_MSG = 'No Living connections';
const NO_TEMPLATES_FOUND_MSG = exports.NO_TEMPLATES_FOUND_MSG = 'There are no templates';
const NO_MODIFICATIONS_FOUND_TEXT = exports.NO_MODIFICATIONS_FOUND_TEXT = 'Template does not contain any modifications';
const JSONPATH_ROOT_SELECTOR = exports.JSONPATH_ROOT_SELECTOR = '$';
const REQUEST_PREFIX = exports.REQUEST_PREFIX = '_request.';
const REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = exports.REQUEST_PREFIX_WITH_JSONPATH_ROOT_SELECTOR = '$._request.';
const WORKFLOW_NAME_RESTRICTIONS = exports.WORKFLOW_NAME_RESTRICTIONS = 'Invalid workflow name. Valid characters are a-z, A-Z, 0-9, -(hyphen), _(underscore).';
let SORT_ORDER = exports.SORT_ORDER = /*#__PURE__*/function (SORT_ORDER) {
  SORT_ORDER["ASC"] = "asc";
  SORT_ORDER["DESC"] = "desc";
  return SORT_ORDER;
}({});
const MAX_DOCS = exports.MAX_DOCS = 1000;
const MAX_DOCS_TO_IMPORT = exports.MAX_DOCS_TO_IMPORT = 100;
const MAX_STRING_LENGTH = exports.MAX_STRING_LENGTH = 100;
const MAX_DESCRIPTION_LENGTH = exports.MAX_DESCRIPTION_LENGTH = 1000;
const MAX_JSON_STRING_LENGTH = exports.MAX_JSON_STRING_LENGTH = 10000;
const MAX_TEMPLATE_STRING_LENGTH = exports.MAX_TEMPLATE_STRING_LENGTH = 10000;
const MAX_BYTES = exports.MAX_BYTES = 1048576; // OSD REST request payload size limit
const MAX_BYTES_FORMATTED = exports.MAX_BYTES_FORMATTED = '1,048,576';
const MAX_WORKFLOW_NAME_TO_DISPLAY = exports.MAX_WORKFLOW_NAME_TO_DISPLAY = 40;
const WORKFLOW_NAME_REGEXP = exports.WORKFLOW_NAME_REGEXP = RegExp('^[a-zA-Z0-9_-]*$');
const INDEX_NAME_REGEXP = exports.INDEX_NAME_REGEXP = WORKFLOW_NAME_REGEXP;
const PROVISION_TIMEOUT = exports.PROVISION_TIMEOUT = '10s'; // the timeout config for synchronous provisioning. https://github.com/opensearch-project/flow-framework/pull/990
const EMPTY_MAP_ENTRY = exports.EMPTY_MAP_ENTRY = {
  key: '',
  value: ''
};
const EMPTY_INPUT_MAP_ENTRY = exports.EMPTY_INPUT_MAP_ENTRY = {
  key: '',
  value: {
    transformType: TRANSFORM_TYPE.FIELD,
    value: ''
  }
};
const EMPTY_OUTPUT_MAP_ENTRY = exports.EMPTY_OUTPUT_MAP_ENTRY = {
  ...EMPTY_INPUT_MAP_ENTRY,
  value: {
    ...EMPTY_INPUT_MAP_ENTRY.value,
    transformType: NO_TRANSFORMATION
  }
};
const MODEL_OUTPUT_SCHEMA_NESTED_PATH = exports.MODEL_OUTPUT_SCHEMA_NESTED_PATH = 'output.properties.inference_results.items.properties.output.items.properties.dataAsMap.properties';
const MODEL_OUTPUT_SCHEMA_FULL_PATH = exports.MODEL_OUTPUT_SCHEMA_FULL_PATH = 'output.properties';
let CONFIG_STEP = exports.CONFIG_STEP = /*#__PURE__*/function (CONFIG_STEP) {
  CONFIG_STEP["INGEST"] = "Ingest pipeline";
  CONFIG_STEP["SEARCH"] = "Search pipeline";
  return CONFIG_STEP;
}({});
let SOURCE_OPTIONS = exports.SOURCE_OPTIONS = /*#__PURE__*/function (SOURCE_OPTIONS) {
  SOURCE_OPTIONS["MANUAL"] = "manual";
  SOURCE_OPTIONS["UPLOAD"] = "upload";
  SOURCE_OPTIONS["EXISTING_INDEX"] = "existing_index";
  return SOURCE_OPTIONS;
}({});
let INSPECTOR_TAB_ID = exports.INSPECTOR_TAB_ID = /*#__PURE__*/function (INSPECTOR_TAB_ID) {
  INSPECTOR_TAB_ID["TEST"] = "test";
  INSPECTOR_TAB_ID["INGEST"] = "ingest";
  INSPECTOR_TAB_ID["ERRORS"] = "errors";
  INSPECTOR_TAB_ID["RESOURCES"] = "resources";
  INSPECTOR_TAB_ID["PREVIEW"] = "preview";
  return INSPECTOR_TAB_ID;
}({});
const INSPECTOR_TABS = exports.INSPECTOR_TABS = [{
  id: INSPECTOR_TAB_ID.TEST,
  name: 'Agentic search',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.INGEST,
  name: 'Ingest response',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.ERRORS,
  name: 'Errors',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.RESOURCES,
  name: 'Resources',
  disabled: false
}, {
  id: INSPECTOR_TAB_ID.PREVIEW,
  name: 'Preview',
  disabled: false
}];

// component IDs for each left nav component. Some may be tied
// to the lower-level form, others are for visual flow purposes only,
// like 'retrieveFromDataSource' and 'searchResults'
let COMPONENT_ID = exports.COMPONENT_ID = /*#__PURE__*/function (COMPONENT_ID) {
  COMPONENT_ID["SOURCE_DATA"] = "ingest.docs";
  COMPONENT_ID["ENRICH_DATA"] = "ingest.enrich";
  COMPONENT_ID["INGEST_DATA"] = "ingest.index";
  COMPONENT_ID["SEARCH_REQUEST"] = "search.request";
  COMPONENT_ID["ENRICH_SEARCH_REQUEST"] = "search.enrichRequest";
  COMPONENT_ID["RUN_QUERY"] = "runQuery";
  COMPONENT_ID["ENRICH_SEARCH_RESPONSE"] = "search.enrichResponse";
  COMPONENT_ID["SEARCH_RESULTS"] = "searchResults";
  return COMPONENT_ID;
}({}); // We have to persist a standalone string to override 'style' component, as setting className does
// not override the default styles from the EuiCard component.
const LEFT_NAV_SELECTED_STYLE = exports.LEFT_NAV_SELECTED_STYLE = '2px solid rgba(128, 128, 128, 0.8)';

/**
 * Agents / tools constants
 */

// Derived from https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/agents/index/
let AGENT_TYPE = exports.AGENT_TYPE = /*#__PURE__*/function (AGENT_TYPE) {
  AGENT_TYPE["FLOW"] = "flow";
  AGENT_TYPE["CONVERSATIONAL"] = "conversational";
  return AGENT_TYPE;
}({}); // TODO: add back PER when there is concrete examples / models to give to users as reference
// PLAN_EXECUTE_REFLECT = 'plan_execute_and_reflect',
// Tool types supported by agents.
// Derived from https://docs.opensearch.org/latest/ml-commons-plugin/agents-tools/tools/index/
let TOOL_TYPE = exports.TOOL_TYPE = /*#__PURE__*/function (TOOL_TYPE) {
  TOOL_TYPE["QUERY_PLANNING"] = "QueryPlanningTool";
  TOOL_TYPE["SEARCH_INDEX"] = "SearchIndexTool";
  TOOL_TYPE["LIST_INDEX"] = "ListIndexTool";
  TOOL_TYPE["INDEX_MAPPING"] = "IndexMappingTool";
  TOOL_TYPE["WEB_SEARCH"] = "WebSearchTool";
  return TOOL_TYPE;
}({});
let TOOL_DESCRIPTION = exports.TOOL_DESCRIPTION = /*#__PURE__*/function (TOOL_DESCRIPTION) {
  TOOL_DESCRIPTION["QUERY_PLANNING"] = "Generates an OpenSearch query domain-specific language (DSL) query from a natural language question";
  TOOL_DESCRIPTION["SEARCH_INDEX"] = "Searches an index using a query written in query domain-specific language (DSL)";
  TOOL_DESCRIPTION["LIST_INDEX"] = "Retrieves index information for the OpenSearch cluster";
  TOOL_DESCRIPTION["INDEX_MAPPING"] = "Retrieves index mapping and setting information for an index";
  TOOL_DESCRIPTION["WEB_SEARCH"] = "Answers a user\u2019s question using a web search";
  return TOOL_DESCRIPTION;
}({}); // Memory types supported by agents.
// Derived from https://docs.opensearch.org/latest/ml-commons-plugin/api/agent-apis/register-agent/
let AGENT_MEMORY_TYPE = exports.AGENT_MEMORY_TYPE = /*#__PURE__*/function (AGENT_MEMORY_TYPE) {
  AGENT_MEMORY_TYPE["CONVERSATION_INDEX"] = "conversation_index";
  return AGENT_MEMORY_TYPE;
}({});
let CONNECTOR_PROTOCOL = exports.CONNECTOR_PROTOCOL = /*#__PURE__*/function (CONNECTOR_PROTOCOL) {
  CONNECTOR_PROTOCOL["AWS_SIGV4"] = "aws_sigv4";
  CONNECTOR_PROTOCOL["HTTP"] = "http";
  CONNECTOR_PROTOCOL["MCP_SSE"] = "mcp_sse";
  CONNECTOR_PROTOCOL["MCP_STREAMABLE_HTTP"] = "mcp_streamable_http";
  return CONNECTOR_PROTOCOL;
}({});
let AGENT_LLM_INTERFACE_TYPE = exports.AGENT_LLM_INTERFACE_TYPE = /*#__PURE__*/function (AGENT_LLM_INTERFACE_TYPE) {
  AGENT_LLM_INTERFACE_TYPE["OPENAI"] = "openai/v1/chat/completions";
  AGENT_LLM_INTERFACE_TYPE["BEDROCK_CLAUDE"] = "bedrock/converse/claude";
  AGENT_LLM_INTERFACE_TYPE["BEDROCK_DEEPSEEK"] = "bedrock/converse/deepseek_r1";
  return AGENT_LLM_INTERFACE_TYPE;
}({});
let RESPONSE_FILTER_TYPE = exports.RESPONSE_FILTER_TYPE = /*#__PURE__*/function (RESPONSE_FILTER_TYPE) {
  RESPONSE_FILTER_TYPE["OPENAI"] = "$.choices[0].message.content";
  RESPONSE_FILTER_TYPE["BEDROCK_CLAUDE"] = "$.output.message.content[0].text";
  return RESPONSE_FILTER_TYPE;
}({});
const NEW_AGENT_PLACEHOLDER = exports.NEW_AGENT_PLACEHOLDER = 'new_agent';
const NEW_AGENT_ID_PLACEHOLDER = exports.NEW_AGENT_ID_PLACEHOLDER = 'New agent (unsaved)';
const AGENT_ID_PATH = exports.AGENT_ID_PATH = 'search.requestAgentId';
const EMPTY_AGENT = exports.EMPTY_AGENT = {
  type: '',
  name: '',
  description: '',
  tools: [],
  llm: {
    model_id: ''
  },
  parameters: {
    _llm_interface: ''
  }
};
const DEFAULT_AGENT = exports.DEFAULT_AGENT = {
  ...EMPTY_AGENT,
  type: AGENT_TYPE.CONVERSATIONAL,
  name: 'My agent',
  description: '',
  tools: [{
    type: TOOL_TYPE.QUERY_PLANNING
  }],
  memory: {
    type: AGENT_MEMORY_TYPE.CONVERSATION_INDEX
  }
};
const DEFAULT_MCP_SERVER = exports.DEFAULT_MCP_SERVER = {
  mcp_connector_id: '',
  tool_filters: []
};
const EXAMPLE_PUT_AGENTIC_SEARCH_PIPELINE = exports.EXAMPLE_PUT_AGENTIC_SEARCH_PIPELINE = `PUT _search/pipeline/agentic-pipeline
{
  "request_processors": [
    {
      "agentic_query_translator": {
        "agent_id": "${AGENT_ID_PATTERN}"
      }
    }
  ],
  "response_processors": [
    {
      "agentic_context": {
        "agent_steps_summary": true,
        "dsl_query": true
      }
    }
  ]
}`;
const EXAMPLE_AGENTIC_SEARCH_QUERY = exports.EXAMPLE_AGENTIC_SEARCH_QUERY = `GET <your-index>/_search?search_pipeline=agentic-pipeline
{
  "query": {
    "agentic": {
      "query_text": "<your-search-query>",
    }
  }
}`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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