"use strict";

var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// https://github.com/elastic/eui/issues/2530
jest.mock('@elastic/eui/lib/components/icon', () => ({
  EuiIcon: () => /*#__PURE__*/_react.default.createElement("div", null, "EuiIconMock"),
  __esModule: true,
  IconPropType: require('@elastic/eui/lib/components/icon/icon').IconPropType,
  ICON_TYPES: require('@elastic/eui/lib/components/icon/icon').TYPES,
  ICON_SIZES: require('@elastic/eui/lib/components/icon/icon').SIZES,
  ICON_COLORS: require('@elastic/eui/lib/components/icon/icon').COLORS
}));
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'some_make_id');
jest.mock('@elastic/eui/lib/services/accessibility', () => ({
  htmlIdGenerator: () => () => 'generated-id',
  cascadingMenuKeys: require('@elastic/eui/lib/services/accessibility/cascading_menu_keys'),
  comboBoxKeys: require('@elastic/eui/lib/services/accessibility/combo_box_keys'),
  accessibleClickKeys: require('@elastic/eui/lib/services/accessibility/accessible_click_keys')
}));

// https://github.com/facebook/jest/issues/5785
// https://github.com/facebook/jest/pull/5267#issuecomment-356605468
beforeEach(() => {
  jest.spyOn(console, 'error');
  console.error.mockImplementation(() => {});
});
afterEach(() => {
  console.error.mockRestore();
});
window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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