"use strict";

var _events = require("events");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

var __extends = void 0 && (void 0).__extends || function () {
  var extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return function (d, b) {
    extendStatics(d, b);
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();
module.exports = {};
Object.defineProperty(module.exports, '__esModule', {
  value: true
});
var Util = /** @class */function () {
  function Util() {}
  Util.clone = function ($target, config) {
    var recurse = true; // set true so childList we'll always check the first level
    return function copy($target) {
      var elestruct = {
        /** @type {Node} */
        node: $target,
        charData: null,
        attr: null,
        kids: null
      };
      // Store current character data of target text or comment node if the config requests
      // those properties to be observed.
      if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
        elestruct.charData = $target.nodeValue;
      } else {
        // Add attr only if subtree is specified or top level and avoid if
        // attributes is a document object (#13).
        if (config.attr && recurse && $target.nodeType === 1) {
          /**
           * clone live attribute list to an object structure {name: val}
           * @type {Object.<string, string>}
           */
          elestruct.attr = Util.reduce($target.attributes, function (memo, attr) {
            if (!config.afilter || config.afilter[attr.name]) {
              memo[attr.name] = attr.value;
            }
            return memo;
          }, {});
        }
        // whether we should iterate the children of $target node
        if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
          /** @type {Array.<!Object>} : Array of custom clone */
          elestruct.kids = Util.map($target.childNodes, copy);
        }
        recurse = config.descendents;
      }
      return elestruct;
    }($target);
  };
  /**
   * indexOf an element in a collection of custom nodes
   *
   * @param {NodeList} set
   * @param {!Object} $node : A custom cloned nodeg333
   * @param {number} idx : index to start the loop
   * @return {number}
   */
  Util.indexOfCustomNode = function (set, $node, idx) {
    var JSCompiler_renameProperty = function (a) {
      return a;
    };
    return this.indexOf(set, $node, idx, JSCompiler_renameProperty('node'));
  };
  /**
   * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
   *
   * @param {Node} $ele
   * @return {(string|number)}
   */
  Util.getElementId = function ($ele) {
    try {
      return $ele.id || ($ele[this.expando] = $ele[this.expando] || this.counter++);
    } catch (e) {
      // ie <8 will throw if you set an unknown property on a text node
      try {
        return $ele.nodeValue; // naive
      } catch (shitie) {
        // when text node is removed: https://gist.github.com/megawac/8355978 :(
        return this.counter++;
      }
    }
  };
  /**
   * **map** Apply a mapping function to each item of a set
   * @param {Array|NodeList} set
   * @param {Function} iterator
   */
  Util.map = function (set, iterator) {
    var results = [];
    for (var index = 0; index < set.length; index++) {
      results[index] = iterator(set[index], index, set);
    }
    return results;
  };
  /**
   * **Reduce** builds up a single result from a list of values
   * @param {Array|NodeList|NamedNodeMap} set
   * @param {Function} iterator
   * @param {*} [memo] Initial value of the memo.
   */
  Util.reduce = function (set, iterator, memo) {
    for (var index = 0; index < set.length; index++) {
      memo = iterator(memo, set[index], index, set);
    }
    return memo;
  };
  /**
   * **indexOf** find index of item in collection.
   * @param {Array|NodeList} set
   * @param {Object} item
   * @param {number} idx
   * @param {string} [prop] Property on set item to compare to item
   */
  Util.indexOf = function (set, item, idx, prop) {
    for (; /*idx = ~~idx*/idx < set.length; idx++) {
      // start idx is always given as this is internal
      if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
    }
    return -1;
  };
  /**
   * @param {Object} obj
   * @param {(string|number)} prop
   * @return {boolean}
   */
  Util.has = function (obj, prop) {
    return obj[prop] !== undefined; // will be nicely inlined by gcc
  };

  Util.counter = 1;
  Util.expando = 'mo_id';
  return Util;
}();
module.exports.Util = Util;
var MutationObserver = /** @class */function () {
  function MutationObserver(listener) {
    var _this = this;
    this._watched = [];
    this._listener = null;
    this._period = 30;
    this._timeout = null;
    this._disposed = false;
    this._notifyListener = null;
    this._watched = [];
    this._listener = listener;
    this._period = 30;
    this._notifyListener = function () {
      _this.scheduleMutationCheck(_this);
    };
  }
  MutationObserver.prototype.observe = function ($target, config) {
    var settings = {
      attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
      // some browsers enforce that subtree must be set with childList, attributes or characterData.
      // We don't care as spec doesn't specify this rule.
      kids: !!config.childList,
      descendents: !!config.subtree,
      charData: !!(config.characterData || config.characterDataOldValue),
      afilter: null
    };
    MutationNotifier.getInstance().on('changed', this._notifyListener);
    var watched = this._watched;
    // remove already observed target element from pool
    for (var i = 0; i < watched.length; i++) {
      if (watched[i].tar === $target) watched.splice(i, 1);
    }
    if (config.attributeFilter) {
      /**
       * converts to a {key: true} dict for faster lookup
       * @type {Object.<String,Boolean>}
       */
      settings.afilter = Util.reduce(config.attributeFilter, function (a, b) {
        a[b] = true;
        return a;
      }, {});
    }
    watched.push({
      tar: $target,
      fn: this.createMutationSearcher($target, settings)
    });
  };
  MutationObserver.prototype.takeRecords = function () {
    var mutations = [];
    var watched = this._watched;
    for (var i = 0; i < watched.length; i++) {
      watched[i].fn(mutations);
    }
    return mutations;
  };
  MutationObserver.prototype.disconnect = function () {
    this._watched = []; // clear the stuff being observed
    MutationNotifier.getInstance().removeListener('changed', this._notifyListener);
    this._disposed = true;
    clearTimeout(this._timeout); // ready for garbage collection
    this._timeout = null;
  };
  MutationObserver.prototype.createMutationSearcher = function ($target, config) {
    var _this = this;
    /** type {Elestuct} */
    var $oldstate = Util.clone($target, config); // create the cloned datastructure
    /**
     * consumes array of mutations we can push to
     *
     * @param {Array.<MutationRecord>} mutations
     */
    return function (mutations) {
      var olen = mutations.length;
      var dirty;
      if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
        mutations.push(new MutationRecord({
          type: 'characterData',
          target: $target,
          oldValue: $oldstate.charData
        }));
      }
      // Alright we check base level changes in attributes... easy
      if (config.attr && $oldstate.attr) {
        _this.findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
      }
      // check childlist or subtree for mutations
      if (config.kids || config.descendents) {
        dirty = _this.searchSubtree(mutations, $target, $oldstate, config);
      }
      // reclone data structure if theres changes
      if (dirty || mutations.length !== olen) {
        /** type {Elestuct} */
        $oldstate = Util.clone($target, config);
      }
    };
  };
  MutationObserver.prototype.scheduleMutationCheck = function (observer) {
    var _this = this;
    // Only schedule if there isn't already a timer.
    if (!observer._timeout) {
      observer._timeout = setTimeout(function () {
        return _this.mutationChecker(observer);
      }, this._period);
    }
  };
  MutationObserver.prototype.mutationChecker = function (observer) {
    // allow scheduling a new timer.
    observer._timeout = null;
    var mutations = observer.takeRecords();
    if (mutations.length) {
      // fire away
      // calling the listener with context is not spec but currently consistent with FF and WebKit
      observer._listener(mutations, observer);
    }
  };
  MutationObserver.prototype.searchSubtree = function (mutations, $target, $oldstate, config) {
    var _this = this;
    // Track if the tree is dirty and has to be recomputed (#14).
    var dirty;
    /*
     * Helper to identify node rearrangment and stuff...
     * There is no gaurentee that the same node will be identified for both added and removed nodes
     * if the positions have been shuffled.
     * conflicts array will be emptied by end of operation
     */
    var _resolveConflicts = function (conflicts, node, $kids, $oldkids, numAddedNodes) {
      // the distance between the first conflicting node and the last
      var distance = conflicts.length - 1;
      // prevents same conflict being resolved twice consider when two nodes switch places.
      // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)
      var counter = -~((distance - numAddedNodes) / 2);
      var $cur;
      var oldstruct;
      var conflict;
      while (conflict = conflicts.pop()) {
        $cur = $kids[conflict.i];
        oldstruct = $oldkids[conflict.j];
        // attempt to determine if there was node rearrangement... won't gaurentee all matches
        // also handles case where added/removed nodes cause nodes to be identified as conflicts
        if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
          mutations.push(new MutationRecord({
            type: 'childList',
            target: node,
            addedNodes: [$cur],
            removedNodes: [$cur],
            // haha don't rely on this please
            nextSibling: $cur.nextSibling,
            previousSibling: $cur.previousSibling
          }));
          counter--; // found conflict
        }
        // Alright we found the resorted nodes now check for other types of mutations
        if (config.attr && oldstruct.attr) _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
        if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
          mutations.push(new MutationRecord({
            type: 'characterData',
            target: $cur,
            oldValue: oldstruct.charData
          }));
        }
        // now look @ subtree
        if (config.descendents) _findMutations($cur, oldstruct);
      }
    };
    /**
     * Main worker. Finds and adds mutations if there are any
     * @param {Node} node
     * @param {!Object} old : A cloned data structure using internal clone
     */
    var _findMutations = function (node, old) {
      var $kids = node.childNodes;
      var $oldkids = old.kids;
      var klen = $kids.length;
      // $oldkids will be undefined for text and comment nodes
      var olen = $oldkids ? $oldkids.length : 0;
      // if (!olen && !klen) return; // both empty; clearly no changes
      // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
      // map of checked element of ids to prevent registering the same conflict twice
      var map;
      // array of potential conflicts (ie nodes that may have been re arranged)
      var conflicts;
      var id; // element id from getElementId helper
      var idx; // index of a moved or inserted element
      var oldstruct;
      // current and old nodes
      var $cur;
      var $old;
      // track the number of added nodes so we can resolve conflicts more accurately
      var numAddedNodes = 0;
      // iterate over both old and current child nodes at the same time
      var i = 0;
      var j = 0;
      // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)
      while (i < klen || j < olen) {
        // current and old nodes at the indexs
        $cur = $kids[i];
        oldstruct = $oldkids[j];
        $old = oldstruct && oldstruct.node;
        if ($cur === $old) {
          // expected case - optimized for this case
          // check attributes as specified by config
          if (config.attr && oldstruct.attr) {
            /* oldstruct.attr instead of textnode check */
            _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
          }
          // check character data if node is a comment or textNode and it's being observed
          if (config.charData && oldstruct.charData !== undefined && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(new MutationRecord({
              type: 'characterData',
              target: $cur
            }));
          }
          // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array
          if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
          // recurse on next level of children. Avoids the recursive call when there are no children left to iterate
          if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) _findMutations($cur, oldstruct);
          i++;
          j++;
        } else {
          // (uncommon case) lookahead until they are the same again or the end of children
          dirty = true;
          if (!map) {
            // delayed initalization (big perf benefit)
            map = {};
            conflicts = [];
          }
          if ($cur) {
            // check id is in the location map otherwise do a indexOf search
            if (!map[id = Util.getElementId($cur)]) {
              // to prevent double checking
              // mark id as found
              map[id] = true;
              // custom indexOf using comparitor checking oldkids[i].node === $cur
              if ((idx = Util.indexOfCustomNode($oldkids, $cur, j)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: node,
                    addedNodes: [$cur],
                    nextSibling: $cur.nextSibling,
                    previousSibling: $cur.previousSibling
                  }));
                  numAddedNodes++;
                }
              } else {
                conflicts.push({
                  i: i,
                  j: idx
                });
              }
            }
            i++;
          }
          if ($old &&
          // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
          $old !== $kids[i]) {
            if (!map[id = Util.getElementId($old)]) {
              map[id] = true;
              if ((idx = Util.indexOf($kids, $old, i)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: old.node,
                    removedNodes: [$old],
                    nextSibling: $oldkids[j + 1],
                    previousSibling: $oldkids[j - 1]
                  }));
                  numAddedNodes--;
                }
              } else {
                conflicts.push({
                  i: idx,
                  j: j
                });
              }
            }
            j++;
          }
        } // end uncommon case
      } // end loop
      // resolve any remaining conflicts
      if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
    };
    _findMutations($target, $oldstate);
    return dirty;
  };
  MutationObserver.prototype.findAttributeMutations = function (mutations, $target, $oldstate, filter) {
    var checked = {};
    var attributes = $target.attributes;
    var attr;
    var name;
    var i = attributes.length;
    while (i--) {
      attr = attributes[i];
      name = attr.name;
      if (!filter || Util.has(filter, name)) {
        if (attr.value !== $oldstate[name]) {
          // The pushing is redundant but gzips very nicely
          mutations.push(new MutationRecord({
            type: 'attributes',
            target: $target,
            attributeName: name,
            oldValue: $oldstate[name],
            attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined
          }));
        }

        checked[name] = true;
      }
    }
    for (name in $oldstate) {
      if (!checked[name]) {
        mutations.push(new MutationRecord({
          target: $target,
          type: 'attributes',
          attributeName: name,
          oldValue: $oldstate[name]
        }));
      }
    }
  };
  return MutationObserver;
}();
module.exports.MutationObserver = MutationObserver;
var MutationRecord = /** @class */function () {
  function MutationRecord(data) {
    var settings = {
      type: null,
      target: null,
      addedNodes: [],
      removedNodes: [],
      previousSibling: null,
      nextSibling: null,
      attributeName: null,
      attributeNamespace: null,
      oldValue: null
    };
    for (var prop in data) {
      if (Util.has(settings, prop) && data[prop] !== undefined) settings[prop] = data[prop];
    }
    return settings;
  }
  return MutationRecord;
}();
module.exports.MutationRecord = MutationRecord;
var MutationNotifier = /** @class */function (_super) {
  __extends(MutationNotifier, _super);
  function MutationNotifier() {
    var _this = _super.call(this) || this;
    _this.setMaxListeners(100);
    return _this;
  }
  MutationNotifier.getInstance = function () {
    if (!MutationNotifier._instance) {
      MutationNotifier._instance = new MutationNotifier();
    }
    return MutationNotifier._instance;
  };
  MutationNotifier.prototype.destruct = function () {
    this.removeAllListeners('changed');
  };
  MutationNotifier.prototype.notifyChanged = function (node) {
    this.emit('changed', node);
  };
  MutationNotifier._instance = null;
  return MutationNotifier;
}(_events.EventEmitter);
module.exports.MutationNotifier = MutationNotifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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