"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
process.env.TZ = 'UTC';
module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.js', '<rootDir>/test/setupTests.js', '<rootDir>/test/enzyme.js'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.js'],
  modulePaths: ['node_modules', `../../node_modules`],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(jpg|jpeg|png|gif|eot|otf|webp|svg|ttf|woff|woff2|mp4|webm|wav|mp3|m4a|aac|oga)$': '<rootDir>/test/mocks/styleMock.js',
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.js',
    '^ui/(.*)': '<rootDir>/../../src/legacy/ui/public/$1/'
  },
  snapshotSerializers: ['../../node_modules/enzyme-to-json/serializer'],
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.ts', '**/*.test.tsx'],
  coveragePathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/', '<rootDir>/test/'],
  clearMocks: true,
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  modulePathIgnorePatterns: [],
  testEnvironment: 'jest-environment-jsdom'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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