"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlightsSavedObjects = void 0;
var _i18n = require("@osd/i18n");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const layerList = config => [{
  name: 'Default map',
  description: '',
  type: 'opensearch_vector_tile_map',
  id: '15bc3560-700e-479d-b49b-be5ece0451ce',
  zoomRange: [0, 22],
  opacity: 100,
  visibility: 'visible',
  source: {
    dataURL: config.opensearchVectorTileDataUrl
  },
  style: {
    styleURL: config.opensearchVectorTileStyleUrl
  }
}, {
  name: 'Flights On Time',
  description: 'Shows flights that are on time',
  type: 'documents',
  id: '033e870c-4195-48ce-8cc1-e428f0545ce4',
  zoomRange: [0, 6],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'FlightNum', 'Carrier', 'FlightTimeMin'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          FlightDelay: false
        }
      },
      $state: {
        store: 'appState'
      }
    }, {
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          Cancelled: false
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#36f20b',
    borderColor: '#36f20b',
    borderThickness: 1,
    markerSize: 5
  }
}, {
  name: 'Delayed Flights',
  description: 'Shows flights that are having delay',
  type: 'documents',
  id: '7ccae1a8-770d-4565-8c91-6125764fd344',
  zoomRange: [3, 6],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'Carrier', 'FlightDelayMin', 'FlightDelayType'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          FlightDelay: true
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#DA8B45',
    borderColor: '#DA8B45',
    borderThickness: 1,
    markerSize: 5
  }
}, {
  name: 'Cancelled Flights',
  description: 'Shows flights that are cancelled',
  type: 'documents',
  id: '70a61cb4-bea5-4a7b-8f2b-e6debd4334dd',
  zoomRange: [4, 22],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'FlightNum', 'Carrier'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          Cancelled: true
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#f40a0a',
    borderColor: '#f40a0a',
    borderThickness: 1,
    markerSize: 5
  }
}];
const getFlightsSavedObjects = config => {
  return [{
    id: '88a24e6c-0216-4f76-8bc7-c8db6c8705da',
    type: 'map',
    updated_at: '2023-02-20T03:57:15.482Z',
    version: 'WzIzLDFd',
    migrationVersion: {},
    attributes: {
      title: _i18n.i18n.translate('home.sampleData.flightsSpec.flightsStatusDestinationLocationMaps', {
        defaultMessage: '[Flights] Flights Status on Maps Destination Location'
      }),
      description: 'Sample map that shows flights at destination location that are on time, delayed and cancelled within a given time range.',
      layerList: JSON.stringify(layerList(config)),
      mapState: '{"timeRange":{"from":"now-1w","to":"now"},"query":{"query":"","language":"kuery"},"refreshInterval":{"pause":true,"value":12000}}'
    },
    references: []
  }];
};
exports.getFlightsSavedObjects = getFlightsSavedObjects;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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