"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class OpensearchService {
  constructor(driver) {
    _defineProperty(this, "getIndex", async (context, req, res) => {
      const dataSourceRefId = req.query.dataSourceId;
      try {
        if (dataSourceRefId) {
          const remoteDataSourceClient = context.dataSource.opensearch.legacy.getClient(dataSourceRefId).callAPI;
          const {
            index
          } = req.body;
          const indices = await remoteDataSourceClient('cat.indices', {
            index,
            format: 'json',
            h: 'health,index,status'
          });
        } else {
          const {
            callAsCurrentUser
          } = this.driver.asScoped(req);
          const {
            index
          } = req.body;
          const indices = await callAsCurrentUser;
        }
        return res.ok({
          body: {
            ok: true,
            resp: indices
          }
        });
      } catch (err) {
        // Opensearch throws an index_not_found_exception which we'll treat as a success
        if (err.statusCode === 404) {
          return res.ok({
            body: {
              ok: false,
              resp: []
            }
          });
        } else {
          return res.ok({
            body: {
              ok: false,
              resp: err.message
            }
          });
        }
      }
    });
    this.driver = driver;
  }
}
exports.default = OpensearchService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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