"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class GeospatialService {
  constructor(driver) {
    _defineProperty(this, "uploadGeojson", async (context, req, res) => {
      const dataSourceRefId = req.query.dataSourceId;
      let uploadResponse;
      try {
        if (dataSourceRefId) {
          const remoteDataSourceClient = context.dataSource.opensearch.legacy.getClient(dataSourceRefId).callAPI;
          uploadResponse = await remoteDataSourceClient('geospatial.geospatialQuery', {
            body: req.body
          });
        } else {
          const {
            callAsCurrentUser
          } = await this.driver.asScoped(req);
          uploadResponse = await callAsCurrentUser('geospatial.geospatialQuery', {
            body: req.body
          });
        }
        return res.ok({
          body: {
            ok: true,
            resp: uploadResponse
          }
        });
      } catch (err) {
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    this.driver = driver;
  }
}
exports.default = GeospatialService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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