"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSavedObjectsType = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const mapSavedObjectsType = exports.mapSavedObjectsType = {
  name: 'map',
  hidden: false,
  namespaceType: 'agnostic',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      return {
        path: `/app/maps-dashboards#/${encodeURIComponent(obj.id)}`,
        uiCapabilitiesPath: 'map.show'
      };
    },
    getEditUrl(obj) {
      return `/management/opensearch-dashboards/objects/map/${encodeURIComponent(obj.id)}`;
    }
  },
  mappings: {
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      layerList: {
        type: 'text',
        index: false
      },
      uiState: {
        type: 'text',
        index: false
      },
      mapState: {
        type: 'text',
        index: false
      },
      version: {
        type: 'integer'
      },
      // Need to add a kibanaSavedObjectMeta attribute here to follow the current saved object flow
      // When we save a saved object, the saved object plugin will extract the search source into two parts
      // Some information will be put into kibanaSavedObjectMeta while others will be created as a reference object and pushed to the reference array
      kibanaSavedObjectMeta: {
        properties: {
          searchSourceJSON: {
            type: 'text',
            index: false
          }
        }
      }
    }
  },
  migrations: {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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