"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statsRoute = statsRoute;
var _common = require("../../common");
var _stats_helper = require("../common/stats/stats_helper");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function statsRoute(router, logger) {
  router.get({
    path: `${_common.APP_API}${_common.APP_PATH.STATS}`,
    validate: {}
  }, async (context, request, response) => {
    try {
      const savedObjectsClient = context.core.savedObjects.client;
      const mapsSavedObjects = await (0, _stats_helper.getMapSavedObjects)(savedObjectsClient, _common.PER_PAGE_REQUEST_NUMBER);
      const stats = (0, _stats_helper.getStats)(mapsSavedObjects);
      return response.ok({
        body: stats
      });
    } catch (error) {
      logger.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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