"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// eslint-disable-next-line import/no-default-export
function _default(services, router) {
  router.post({
    path: '/api/custom_import_map/_upload',
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.maybe(_configSchema.schema.object({}, {
        unknowns: 'allow'
      }))
    },
    options: {
      body: {
        accepts: 'application/json',
        maxBytes: _common.MAX_FILE_PAYLOAD_SIZE // 25 MB payload limit for custom geoJSON feature
      }
    }
  }, services.uploadGeojson);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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