"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomImportMapPlugin = void 0;
var _operators = require("rxjs/operators");
var _flights_saved_objects = require("./services/sample_data/flights_saved_objects");
var _clusters = require("./clusters");
var _services = require("./services");
var _routes = require("../server/routes");
var _saved_objects = require("./saved_objects");
var _capabilities_provider = require("./saved_objects/capabilities_provider");
var _geospatial_plugin = _interopRequireDefault(require("./clusters/geospatial_plugin"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class CustomImportMapPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    _defineProperty(this, "config$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
    this.config$ = initializerContext.config.create();
  }

  // Adds dashboards-maps saved objects to existing sample datasets using home plugin
  addMapsSavedObjects(home, config) {
    home.sampleData.addSavedObjectsToSampleDataset('flights', (0, _flights_saved_objects.getFlightsSavedObjects)(config));
  }
  async setup(core, plugins) {
    this.logger.debug('customImportMap: Setup');
    // @ts-ignore
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    // @ts-ignore
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const geospatialClient = (0, _clusters.createGeospatialCluster)(core, globalConfig);
    // Initialize services
    const geospatialService = new _services.GeospatialService(geospatialClient);
    const opensearchService = new _services.OpensearchService(geospatialClient);
    const router = core.http.createRouter();
    const {
      home,
      dataSource
    } = plugins;
    if (dataSource) {
      dataSource.registerCustomApiSchema(_geospatial_plugin.default);
    }

    // Register server side APIs
    (0, _routes.geospatial)(geospatialService, router);
    (0, _routes.opensearch)(opensearchService, router);
    (0, _routes.statsRoute)(router, this.logger);

    // Register saved object types
    core.savedObjects.registerType(_saved_objects.mapSavedObjectsType);

    // Register capabilities
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    if (home) this.addMapsSavedObjects(home, config);
    return {};
  }
  start(core) {
    this.logger.debug('customImportMap: Started');
    return {};
  }
  stop() {}
}
exports.CustomImportMapPlugin = CustomImportMapPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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