"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CustomImportMapPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.CustomImportMapPluginSetup;
  }
});
Object.defineProperty(exports, "CustomImportMapPluginStart", {
  enumerable: true,
  get: function () {
    return _types.CustomImportMapPluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _plugin = require("./plugin");
var _config = require("../common/config");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// This exports static code and TypeScript types,
// as well as, OpenSearch Dashboards Platform `plugin()` initializer.

function plugin(initializerContext) {
  return new _plugin.CustomImportMapPlugin(initializerContext);
}
const config = exports.config = {
  exposeToBrowser: {
    opensearchVectorTileDataUrl: true,
    opensearchVectorTileStyleUrl: true,
    opensearchVectorTileGlyphsUrl: true
  },
  schema: _config.configSchema
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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