"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStats = exports.getMapSavedObjects = void 0;
var _common = require("../../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getStats = mapsSavedObjects => {
  const totalLayersCountByType = buildLayerTypesCountObject();
  let totalLayersFiltersCount = 0;
  const mapsList = [];
  mapsSavedObjects.saved_objects.forEach(mapRes => {
    var _mapRes$attributes, _mapRes$attributes2;
    const layersCountByType = buildLayerTypesCountObject();
    let layersFiltersCount = 0;
    const layerList = mapRes !== null && mapRes !== void 0 && (_mapRes$attributes = mapRes.attributes) !== null && _mapRes$attributes !== void 0 && _mapRes$attributes.layerList ? JSON.parse(mapRes === null || mapRes === void 0 || (_mapRes$attributes2 = mapRes.attributes) === null || _mapRes$attributes2 === void 0 ? void 0 : _mapRes$attributes2.layerList) : [];
    layerList.forEach(layer => {
      var _layer$source$filters, _layer$source;
      if (layer.type === _common.DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP) {
        layersCountByType[layer.source.customType]++;
        totalLayersCountByType[layer.source.customType]++;
      } else {
        layersCountByType[layer.type]++;
        totalLayersCountByType[layer.type]++;
      }
      // @ts-ignore
      const layerFiltersCount = (_layer$source$filters = (_layer$source = layer.source) === null || _layer$source === void 0 || (_layer$source = _layer$source.filters) === null || _layer$source === void 0 ? void 0 : _layer$source.length) !== null && _layer$source$filters !== void 0 ? _layer$source$filters : 0;
      layersFiltersCount += layerFiltersCount;
      totalLayersFiltersCount += layerFiltersCount;
    });
    mapsList.push({
      id: mapRes === null || mapRes === void 0 ? void 0 : mapRes.id,
      layers_filters_total: layersFiltersCount,
      layers_total: {
        ...layersCountByType
      }
    });
  });
  return {
    maps_total: mapsSavedObjects.total,
    layers_filters_total: totalLayersFiltersCount,
    layers_total: {
      ...totalLayersCountByType
    },
    maps_list: mapsList
  };
};
exports.getStats = getStats;
const buildLayerTypesCountObject = () => {
  const layersCountByType = {};
  Object.values(_common.DASHBOARDS_MAPS_LAYER_TYPE).forEach(layerType => {
    if (layerType === _common.DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP) {
      Object.values(_common.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE).forEach(customLayerType => {
        layersCountByType[customLayerType] = 0;
      });
    } else {
      layersCountByType[layerType] = 0;
    }
  });
  return layersCountByType;
};
const getMapSavedObjects = async (savedObjectsClient, perPage) => {
  const mapsSavedObjects = await (savedObjectsClient === null || savedObjectsClient === void 0 ? void 0 : savedObjectsClient.find({
    type: _common.MAP_SAVED_OBJECT_TYPE,
    perPage
  }));
  // If there are more than perPage of maps, we need to make additional requests to get all maps.
  if (mapsSavedObjects.total > perPage) {
    const iterations = Math.ceil(mapsSavedObjects.total / perPage);
    for (let i = 1; i < iterations; i++) {
      const mapsSavedObjectsPage = await (savedObjectsClient === null || savedObjectsClient === void 0 ? void 0 : savedObjectsClient.find({
        type: _common.MAP_SAVED_OBJECT_TYPE,
        perPage,
        page: i + 1
      }));
      mapsSavedObjects.saved_objects = [...mapsSavedObjects.saved_objects, ...mapsSavedObjectsPage.saved_objects];
    }
  }
  return mapsSavedObjects;
};
exports.getMapSavedObjects = getMapSavedObjects;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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