"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = GeospatialPlugin;
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// eslint-disable-next-line import/no-default-export
function GeospatialPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.geospatial = components.clientAction.namespaceFactory();
  const geospatial = Client.prototype.geospatial.prototype;
  geospatial.geospatialQuery = ca({
    url: {
      fmt: `${_shared.UPLOAD_GEOJSON_API_PATH}`
    },
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc2hhcmVkIiwicmVxdWlyZSIsIkdlb3NwYXRpYWxQbHVnaW4iLCJDbGllbnQiLCJjb25maWciLCJjb21wb25lbnRzIiwiY2EiLCJjbGllbnRBY3Rpb24iLCJmYWN0b3J5IiwicHJvdG90eXBlIiwiZ2Vvc3BhdGlhbCIsIm5hbWVzcGFjZUZhY3RvcnkiLCJnZW9zcGF0aWFsUXVlcnkiLCJ1cmwiLCJmbXQiLCJVUExPQURfR0VPSlNPTl9BUElfUEFUSCIsIm1ldGhvZCIsIm1vZHVsZSIsImV4cG9ydHMiLCJkZWZhdWx0Il0sInNvdXJjZXMiOlsiZ2Vvc3BhdGlhbF9wbHVnaW4udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgVVBMT0FEX0dFT0pTT05fQVBJX1BBVEggfSBmcm9tICcuLi8uLi9jb21tb24vY29uc3RhbnRzL3NoYXJlZCc7XHJcblxyXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgaW1wb3J0L25vLWRlZmF1bHQtZXhwb3J0XHJcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIEdlb3NwYXRpYWxQbHVnaW4oQ2xpZW50LCBjb25maWcsIGNvbXBvbmVudHMpIHtcclxuICBjb25zdCBjYSA9IGNvbXBvbmVudHMuY2xpZW50QWN0aW9uLmZhY3Rvcnk7XHJcbiAgQ2xpZW50LnByb3RvdHlwZS5nZW9zcGF0aWFsID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24ubmFtZXNwYWNlRmFjdG9yeSgpO1xyXG4gIGNvbnN0IGdlb3NwYXRpYWwgPSBDbGllbnQucHJvdG90eXBlLmdlb3NwYXRpYWwucHJvdG90eXBlO1xyXG5cclxuICBnZW9zcGF0aWFsLmdlb3NwYXRpYWxRdWVyeSA9IGNhKHtcclxuICAgIHVybDoge1xyXG4gICAgICBmbXQ6IGAke1VQTE9BRF9HRU9KU09OX0FQSV9QQVRIfWAsXHJcbiAgICB9LFxyXG4gICAgbWV0aG9kOiAnUE9TVCcsXHJcbiAgfSk7XHJcbn1cclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxPQUFBLEdBQUFDLE9BQUE7QUFMQTtBQUNBO0FBQ0E7QUFDQTs7QUFJQTtBQUNlLFNBQVNDLGdCQUFnQkEsQ0FBQ0MsTUFBTSxFQUFFQyxNQUFNLEVBQUVDLFVBQVUsRUFBRTtFQUNuRSxNQUFNQyxFQUFFLEdBQUdELFVBQVUsQ0FBQ0UsWUFBWSxDQUFDQyxPQUFPO0VBQzFDTCxNQUFNLENBQUNNLFNBQVMsQ0FBQ0MsVUFBVSxHQUFHTCxVQUFVLENBQUNFLFlBQVksQ0FBQ0ksZ0JBQWdCLENBQUMsQ0FBQztFQUN4RSxNQUFNRCxVQUFVLEdBQUdQLE1BQU0sQ0FBQ00sU0FBUyxDQUFDQyxVQUFVLENBQUNELFNBQVM7RUFFeERDLFVBQVUsQ0FBQ0UsZUFBZSxHQUFHTixFQUFFLENBQUM7SUFDOUJPLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUcsR0FBRUMsK0JBQXdCO0lBQ2xDLENBQUM7SUFDREMsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0FBQ0o7QUFBQ0MsTUFBQSxDQUFBQyxPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9