"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMapLanguage = exports.fromMBtoBytes = void 0;
exports.isEscapeKey = isEscapeKey;
var _i18n = require("@osd/i18n");
var _index = require("./index");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const fromMBtoBytes = sizeInMB => {
  return sizeInMB * 1024 * 1024;
};
exports.fromMBtoBytes = fromMBtoBytes;
const getMapLanguage = () => {
  const OSDLanguage = _i18n.i18n.getLocale().toLowerCase(),
    parts = OSDLanguage.split('-');
  const languageCode = parts.length > 1 ? parts[0] : OSDLanguage;
  return _index.OSD_LANGUAGES.includes(languageCode) ? languageCode : _index.FALLBACK_LANGUAGE;
};
exports.getMapLanguage = getMapLanguage;
function isEscapeKey(e) {
  return e.code === 'Escape';
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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