"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ALLOWED_FILE_EXTENSIONS", {
  enumerable: true,
  get: function () {
    return _shared.ALLOWED_FILE_EXTENSIONS;
  }
});
exports.MAPS_APP_ICON = exports.MAPBOX_GL_DRAW_MODES = exports.MAPBOX_GL_DRAW_CREATE_LISTENER = exports.LAYER_VISIBILITY = exports.LAYER_PANEL_SHOW_LAYER_ICON = exports.LAYER_PANEL_HIDE_LAYER_ICON = exports.LAYER_ICON_TYPE_MAP = exports.FILTER_DRAW_MODE = exports.FALLBACK_LANGUAGE = exports.DRAW_FILTER_SPATIAL_RELATIONS = exports.DRAW_FILTER_SHAPE_TITLE = exports.DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = exports.DRAW_FILTER_RECTANGLE = exports.DRAW_FILTER_POLYGON_DEFAULT_LABEL = exports.DRAW_FILTER_POLYGON = exports.DRAW_FILTER_CANCEL = exports.DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = exports.DOCUMENTS_NONE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MIN_MARKER_SIZE = exports.DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MIN_LABEL_SIZE = exports.DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MAX_MARKER_SIZE = exports.DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MAX_LABEL_SIZE = exports.DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_TOOLTIPS = exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = exports.DOCUMENTS_DEFAULT_MARKER_SIZE = exports.DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_LABEL_SIZE = exports.DOCUMENTS_DEFAULT_LABEL_ENABLES = exports.DOCUMENTS_DEFAULT_LABEL_COLOR = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = exports.DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = exports.DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = exports.DOCUMENTS = exports.DEFAULT_VECTOR_TILE_STYLES = exports.DASHBOARDS_MAPS_LAYER_TYPE = exports.DASHBOARDS_MAPS_LAYER_NAME = exports.DASHBOARDS_MAPS_LAYER_ICON = exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = exports.CUSTOM_MAP = exports.CLUSTER_MIN_BORDER_THICKNESS = exports.CLUSTER_MAX_BORDER_THICKNESS = exports.CLUSTER_DEFAULT_PRECISION = exports.CLUSTER_DEFAULT_PALETTE = exports.CLUSTER_DEFAULT_METRIC_AGG = exports.CLUSTER_DEFAULT_MARKER_BORDER_THICKNESS = exports.CLUSTER_DEFAULT_FILL_TYPE = exports.CLUSTER_DEFAULT_CLUSTER_AGG = exports.CLUSTER = exports.APP_PATH = exports.APP_API = void 0;
Object.defineProperty(exports, "MAPS_APP_ID", {
  enumerable: true,
  get: function () {
    return _shared.MAPS_APP_ID;
  }
});
exports.MAP_SAVED_OBJECT_TYPE = exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = exports.MAP_LAYER_DEFAULT_OPACITY_STEP = exports.MAP_LAYER_DEFAULT_NAME = exports.MAP_LAYER_DEFAULT_MIN_OPACITY = exports.MAP_LAYER_DEFAULT_MAX_OPACITY = exports.MAP_INITIAL_STATE = exports.MAP_DEFAULT_MIN_ZOOM = exports.MAP_DEFAULT_MAX_ZOOM = exports.MAP_DATA_LAYER_DEFAULT_OPACITY = exports.MAPS_VISUALIZATION_DESCRIPTION = void 0;
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE;
  }
});
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE_IN_MB", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE_IN_MB;
  }
});
exports.PER_PAGE_REQUEST_NUMBER = exports.OSD_LANGUAGES = exports.OPENSEARCH_MAP_LAYER = exports.NEW_MAP_LAYER_DEFAULT_PREFIX = exports.MIN_LONGITUDE = exports.MAX_LONGITUDE = exports.MAX_LAYER_NAME_LIMIT = exports.MAX_LAYER_LIMIT = void 0;
Object.defineProperty(exports, "PLUGIN_ID", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_ID;
  }
});
Object.defineProperty(exports, "PLUGIN_NAME", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_NAME;
  }
});
exports.TOOLTIP_STATE = void 0;
Object.defineProperty(exports, "fromMBtoBytes", {
  enumerable: true,
  get: function () {
    return _util.fromMBtoBytes;
  }
});
var _util = require("./util");
var _shared = require("./constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const DOCUMENTS_DEFAULT_MARKER_SIZE = exports.DOCUMENTS_DEFAULT_MARKER_SIZE = 5;
const DOCUMENTS_MIN_MARKER_SIZE = exports.DOCUMENTS_MIN_MARKER_SIZE = 0;
const DOCUMENTS_MAX_MARKER_SIZE = exports.DOCUMENTS_MAX_MARKER_SIZE = 100;
const DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = 1;
const DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = 0;
const DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = 100;
const DOCUMENTS_DEFAULT_REQUEST_NUMBER = exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = 1000;
const DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = false;
const DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = exports.DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = true;
const DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = exports.DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = true;
const DOCUMENTS_DEFAULT_TOOLTIPS = exports.DOCUMENTS_DEFAULT_TOOLTIPS = [];
const DOCUMENTS_DEFAULT_LABEL_ENABLES = exports.DOCUMENTS_DEFAULT_LABEL_ENABLES = false;
let DOCUMENTS_LABEL_TEXT_TYPE = exports.DOCUMENTS_LABEL_TEXT_TYPE = /*#__PURE__*/function (DOCUMENTS_LABEL_TEXT_TYPE) {
  DOCUMENTS_LABEL_TEXT_TYPE["BY_FIELD"] = "by_field";
  DOCUMENTS_LABEL_TEXT_TYPE["FIXED"] = "fixed";
  return DOCUMENTS_LABEL_TEXT_TYPE;
}({});
const DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = DOCUMENTS_LABEL_TEXT_TYPE.BY_FIELD;
const DOCUMENTS_DEFAULT_LABEL_SIZE = exports.DOCUMENTS_DEFAULT_LABEL_SIZE = 15;
const DOCUMENTS_MIN_LABEL_SIZE = exports.DOCUMENTS_MIN_LABEL_SIZE = 1;
const DOCUMENTS_MAX_LABEL_SIZE = exports.DOCUMENTS_MAX_LABEL_SIZE = 100;
const DOCUMENTS_DEFAULT_LABEL_COLOR = exports.DOCUMENTS_DEFAULT_LABEL_COLOR = '#000000';
const DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = '#FFFFFF';
const DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = 20;
const DOCUMENTS_NONE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_NONE_LABEL_BORDER_WIDTH = 0;
const DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = exports.DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = 2;
const DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = 5;
const DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = 10;
const LAYER_PANEL_HIDE_LAYER_ICON = exports.LAYER_PANEL_HIDE_LAYER_ICON = 'eyeClosed';
const LAYER_PANEL_SHOW_LAYER_ICON = exports.LAYER_PANEL_SHOW_LAYER_ICON = 'eye';
const MAP_DATA_LAYER_DEFAULT_OPACITY = exports.MAP_DATA_LAYER_DEFAULT_OPACITY = 70;
const MAP_DEFAULT_MAX_ZOOM = exports.MAP_DEFAULT_MAX_ZOOM = 22;
const MAP_DEFAULT_MIN_ZOOM = exports.MAP_DEFAULT_MIN_ZOOM = 0;
const MAP_LAYER_DEFAULT_MAX_OPACITY = exports.MAP_LAYER_DEFAULT_MAX_OPACITY = 100;
const MAP_LAYER_DEFAULT_MIN_OPACITY = exports.MAP_LAYER_DEFAULT_MIN_OPACITY = 0;
const MAP_LAYER_DEFAULT_NAME = exports.MAP_LAYER_DEFAULT_NAME = 'Default map';
const MAP_LAYER_DEFAULT_OPACITY_STEP = exports.MAP_LAYER_DEFAULT_OPACITY_STEP = 1;
const MAP_REFERENCE_LAYER_DEFAULT_OPACITY = exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = 100;
// Make this configurable from map settings
const MAX_LAYER_LIMIT = exports.MAX_LAYER_LIMIT = 100;
const MAX_LAYER_NAME_LIMIT = exports.MAX_LAYER_NAME_LIMIT = 35;
const MAX_LONGITUDE = exports.MAX_LONGITUDE = 180;
const MIN_LONGITUDE = exports.MIN_LONGITUDE = -180;
const NEW_MAP_LAYER_DEFAULT_PREFIX = exports.NEW_MAP_LAYER_DEFAULT_PREFIX = 'New layer';
const MAP_SAVED_OBJECT_TYPE = exports.MAP_SAVED_OBJECT_TYPE = 'map';
// TODO: Replace with actual app icon
const MAPS_APP_ICON = exports.MAPS_APP_ICON = 'gisApp';
const MAPS_VISUALIZATION_DESCRIPTION = exports.MAPS_VISUALIZATION_DESCRIPTION = 'Create map visualization with multiple layers';
const CLUSTER_DEFAULT_FILL_TYPE = exports.CLUSTER_DEFAULT_FILL_TYPE = 'gradient';
const CLUSTER_DEFAULT_PALETTE = exports.CLUSTER_DEFAULT_PALETTE = 'blue';
const CLUSTER_MIN_BORDER_THICKNESS = exports.CLUSTER_MIN_BORDER_THICKNESS = 0;
const CLUSTER_MAX_BORDER_THICKNESS = exports.CLUSTER_MAX_BORDER_THICKNESS = 100;
const CLUSTER_DEFAULT_MARKER_BORDER_THICKNESS = exports.CLUSTER_DEFAULT_MARKER_BORDER_THICKNESS = 1;
//This is a valid value in geohex,geotile and geohash aggregation.
const CLUSTER_DEFAULT_PRECISION = exports.CLUSTER_DEFAULT_PRECISION = 2;
const CLUSTER_DEFAULT_METRIC_AGG = exports.CLUSTER_DEFAULT_METRIC_AGG = 'count';
const CLUSTER_DEFAULT_CLUSTER_AGG = exports.CLUSTER_DEFAULT_CLUSTER_AGG = 'geohash_grid';

// Starting position [lng, lat] and zoom
const MAP_INITIAL_STATE = exports.MAP_INITIAL_STATE = {
  lng: 0,
  lat: 0,
  zoom: 1
};
const APP_PATH = exports.APP_PATH = {
  LANDING_PAGE_PATH: '/',
  CREATE_MAP: '/create',
  EDIT_MAP: '/:id',
  STATS: '/stats'
};
const APP_API = exports.APP_API = '/api/maps-dashboards';
let DASHBOARDS_MAPS_LAYER_NAME = exports.DASHBOARDS_MAPS_LAYER_NAME = /*#__PURE__*/function (DASHBOARDS_MAPS_LAYER_NAME) {
  DASHBOARDS_MAPS_LAYER_NAME["OPENSEARCH_MAP"] = "OpenSearch map";
  DASHBOARDS_MAPS_LAYER_NAME["DOCUMENTS"] = "Documents";
  DASHBOARDS_MAPS_LAYER_NAME["CUSTOM_MAP"] = "Custom map";
  DASHBOARDS_MAPS_LAYER_NAME["CLUSTER"] = "Cluster";
  return DASHBOARDS_MAPS_LAYER_NAME;
}({});
let DASHBOARDS_MAPS_LAYER_TYPE = exports.DASHBOARDS_MAPS_LAYER_TYPE = /*#__PURE__*/function (DASHBOARDS_MAPS_LAYER_TYPE) {
  DASHBOARDS_MAPS_LAYER_TYPE["OPENSEARCH_MAP"] = "opensearch_vector_tile_map";
  DASHBOARDS_MAPS_LAYER_TYPE["DOCUMENTS"] = "documents";
  DASHBOARDS_MAPS_LAYER_TYPE["CUSTOM_MAP"] = "custom_map";
  DASHBOARDS_MAPS_LAYER_TYPE["CLUSTER"] = "cluster";
  return DASHBOARDS_MAPS_LAYER_TYPE;
}({});
let DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = /*#__PURE__*/function (DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE) {
  DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE["WMS"] = "wms";
  DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE["TMS"] = "tms";
  return DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE;
}({});
let DASHBOARDS_MAPS_LAYER_ICON = exports.DASHBOARDS_MAPS_LAYER_ICON = /*#__PURE__*/function (DASHBOARDS_MAPS_LAYER_ICON) {
  DASHBOARDS_MAPS_LAYER_ICON["OPENSEARCH_MAP"] = "globe";
  DASHBOARDS_MAPS_LAYER_ICON["DOCUMENTS"] = "document";
  DASHBOARDS_MAPS_LAYER_ICON["CUSTOM_MAP"] = "globe";
  DASHBOARDS_MAPS_LAYER_ICON["CLUSTER"] = "heatmap";
  return DASHBOARDS_MAPS_LAYER_ICON;
}({});
let DASHBOARDS_MAPS_LAYER_DESCRIPTION = exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = /*#__PURE__*/function (DASHBOARDS_MAPS_LAYER_DESCRIPTION) {
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["OPENSEARCH_MAP"] = "Use default OpenSearch basemaps.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["DOCUMENTS"] = "View points, lines, and polygons on the map.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["CUSTOM_MAP"] = "Configure maps to use a custom map source.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["CLUSTER"] = "Geospatial data grouped to show density.";
  return DASHBOARDS_MAPS_LAYER_DESCRIPTION;
}({});
const DOCUMENTS = exports.DOCUMENTS = {
  name: DASHBOARDS_MAPS_LAYER_NAME.DOCUMENTS,
  type: DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS,
  icon: DASHBOARDS_MAPS_LAYER_ICON.DOCUMENTS,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.DOCUMENTS
};
const CLUSTER = exports.CLUSTER = {
  name: DASHBOARDS_MAPS_LAYER_NAME.CLUSTER,
  type: DASHBOARDS_MAPS_LAYER_TYPE.CLUSTER,
  icon: DASHBOARDS_MAPS_LAYER_ICON.CLUSTER,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.CLUSTER
};
const OPENSEARCH_MAP_LAYER = exports.OPENSEARCH_MAP_LAYER = {
  name: DASHBOARDS_MAPS_LAYER_NAME.OPENSEARCH_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.OPENSEARCH_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.OPENSEARCH_MAP
};
const CUSTOM_MAP = exports.CUSTOM_MAP = {
  name: DASHBOARDS_MAPS_LAYER_NAME.CUSTOM_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.CUSTOM_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.CUSTOM_MAP
};
const LAYER_VISIBILITY = exports.LAYER_VISIBILITY = {
  NONE: 'none',
  VISIBLE: 'visible'
};
const LAYER_ICON_TYPE_MAP = exports.LAYER_ICON_TYPE_MAP = {
  [DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP]: 'globe',
  [DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS]: 'document',
  [DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP]: 'globe',
  [DASHBOARDS_MAPS_LAYER_TYPE.CLUSTER]: 'heatmap'
};

// refer https://github.com/opensearch-project/i18n-plugin/blob/main/DEVELOPER_GUIDE.md#new-locale for OSD supported languages
const OSD_LANGUAGES = exports.OSD_LANGUAGES = ['en', 'es', 'fr', 'de', 'ja', 'ko', 'zh']; // all these codes are also supported in vector tiles map
const FALLBACK_LANGUAGE = exports.FALLBACK_LANGUAGE = 'en';
let TOOLTIP_STATE = exports.TOOLTIP_STATE = /*#__PURE__*/function (TOOLTIP_STATE) {
  TOOLTIP_STATE["DISPLAY_FEATURES"] = "DISPLAY_FEATURES";
  TOOLTIP_STATE["FILTER_DRAW_SHAPE"] = "FILTER_DRAW_SHAPE";
  return TOOLTIP_STATE;
}({});
let FILTER_DRAW_MODE = exports.FILTER_DRAW_MODE = /*#__PURE__*/function (FILTER_DRAW_MODE) {
  FILTER_DRAW_MODE["NONE"] = "none";
  FILTER_DRAW_MODE["POLYGON"] = "polygon";
  FILTER_DRAW_MODE["RECTANGLE"] = "rectangle";
  return FILTER_DRAW_MODE;
}({}); // Filter is active and set to draw rectangle
const MAPBOX_GL_DRAW_CREATE_LISTENER = exports.MAPBOX_GL_DRAW_CREATE_LISTENER = 'draw.create';
let MAPBOX_GL_DRAW_MODES = exports.MAPBOX_GL_DRAW_MODES = /*#__PURE__*/function (MAPBOX_GL_DRAW_MODES) {
  MAPBOX_GL_DRAW_MODES["DRAW_POLYGON"] = "draw_polygon";
  MAPBOX_GL_DRAW_MODES["DRAW_RECTANGLE"] = "draw_rectangle";
  MAPBOX_GL_DRAW_MODES["SIMPLE_SELECT"] = "simple_select";
  return MAPBOX_GL_DRAW_MODES;
}({});
const DRAW_FILTER_SHAPE_TITLE = exports.DRAW_FILTER_SHAPE_TITLE = 'DRAW SHAPE';
const DRAW_FILTER_POLYGON_DEFAULT_LABEL = exports.DRAW_FILTER_POLYGON_DEFAULT_LABEL = 'polygon';
const DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = exports.DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = 'rectangle';
const DRAW_FILTER_POLYGON = exports.DRAW_FILTER_POLYGON = 'Draw Polygon';
const DRAW_FILTER_CANCEL = exports.DRAW_FILTER_CANCEL = 'Cancel';
const DRAW_FILTER_RECTANGLE = exports.DRAW_FILTER_RECTANGLE = 'Draw Rectangle';
const DRAW_FILTER_SPATIAL_RELATIONS = exports.DRAW_FILTER_SPATIAL_RELATIONS = ['intersects', 'disjoint', 'within'];
const PER_PAGE_REQUEST_NUMBER = exports.PER_PAGE_REQUEST_NUMBER = 50;
const DEFAULT_VECTOR_TILE_STYLES = exports.DEFAULT_VECTOR_TILE_STYLES = {
  BASIC: 'basic',
  DARK: 'dark'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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