"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visNLQSavedObjectType = void 0;
var _vis_type_nlq = require("../../common/constants/vis_type_nlq");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const visNLQSavedObjectType = exports.visNLQSavedObjectType = {
  name: _vis_type_nlq.VIS_NLQ_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle: ({
      attributes: {
        title
      }
    }) => title,
    getInAppUrl({
      id
    }) {
      return {
        path: `/app/text2viz/edit/${encodeURIComponent(id)}`,
        uiCapabilitiesPath: `${_vis_type_nlq.VIS_NLQ_SAVED_OBJECT}.show`
      };
    }
  },
  migrations: {},
  mappings: {
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      visualizationState: {
        type: 'text',
        index: false
      },
      uiState: {
        type: 'text',
        index: false
      },
      version: {
        type: 'integer'
      },
      kibanaSavedObjectMeta: {
        properties: {
          searchSourceJSON: {
            type: 'text',
            index: false
          }
        }
      }
    }
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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