"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addTitleTextLayer = addTitleTextLayer;
exports.checkSingleMetric = checkSingleMetric;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addTitleTextLayer(json) {
  var _layeredSpec$layer;
  if (!json.title) return json;
  const titleTextLayer = {
    mark: {
      type: 'text',
      align: 'center',
      dy: 50,
      fontSize: 16,
      fontWeight: 'bold'
    },
    encoding: {
      text: {
        value: json.title
      }
    }
  };
  let layeredSpec = {
    ...json
  };
  if (!json.layer) {
    const {
      mark,
      encoding,
      ...rest
    } = json;
    layeredSpec = {
      ...rest,
      layer: [{
        mark: {
          type: 'text',
          fontSize: 80,
          fontWeight: 'bold'
        },
        encoding
      }]
    };
  }
  (_layeredSpec$layer = layeredSpec.layer) === null || _layeredSpec$layer === void 0 || _layeredSpec$layer.push(titleTextLayer);
  return layeredSpec;
}

// the sample data format is like : "[{\"flight_count\":2033,\"dayOfWeek\":0}]"
// will check if the string only contains one single key-value pair

function checkSingleMetric(sampleData) {
  const regex = /^"\[\{\\?"[^"]+\\?":[^,}]+\}\]"$/;
  return regex.test(sampleData);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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