"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageParserRunner = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class MessageParserRunner {
  constructor(messageParsers) {
    this.messageParsers = messageParsers;
  }
  async run(interaction, options) {
    const sortedParsers = [...this.messageParsers];
    sortedParsers.sort((parserA, parserB) => {
      const {
        order: orderA = 999
      } = parserA;
      const {
        order: orderB = 999
      } = parserB;
      return orderA - orderB;
    });
    let results = [];
    /**
     * Use a variable to record the index.
     */
    let messageIndex = -1;
    for (const messageParser of sortedParsers) {
      let tempResult = [];
      try {
        tempResult = await messageParser.parserProvider(interaction, options);
        /**
         * Make sure the tempResult is an array.
         */
        if (!Array.isArray(tempResult)) {
          tempResult = [];
        }
      } catch (e) {
        tempResult = [];
      }
      results = [...results, ...tempResult.map(item => {
        messageIndex++;
        return {
          ...item,
          messageId: `${interaction.interaction_id}_${messageIndex}`
        };
      })];
    }
    return results;
  }
}
exports.MessageParserRunner = MessageParserRunner;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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