"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOpenSearchClientTransport = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getOpenSearchClientTransport = async ({
  context,
  dataSourceId
}) => {
  if (dataSourceId && context.dataSource) {
    return (await context.dataSource.opensearch.getClient(dataSourceId)).transport;
  }
  return context.core.opensearch.client.asCurrentUser.transport;
};
exports.getOpenSearchClientTransport = getOpenSearchClientTransport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJnZXRPcGVuU2VhcmNoQ2xpZW50VHJhbnNwb3J0IiwiY29udGV4dCIsImRhdGFTb3VyY2VJZCIsImRhdGFTb3VyY2UiLCJvcGVuc2VhcmNoIiwiZ2V0Q2xpZW50IiwidHJhbnNwb3J0IiwiY29yZSIsImNsaWVudCIsImFzQ3VycmVudFVzZXIiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsiZ2V0X29wZW5zZWFyY2hfY2xpZW50X3RyYW5zcG9ydC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxyXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcclxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcclxuICovXHJcblxyXG5pbXBvcnQgeyBPcGVuU2VhcmNoQ2xpZW50LCBSZXF1ZXN0SGFuZGxlckNvbnRleHQgfSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xyXG5cclxuZXhwb3J0IGNvbnN0IGdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQgPSBhc3luYyAoe1xyXG4gIGNvbnRleHQsXHJcbiAgZGF0YVNvdXJjZUlkLFxyXG59OiB7XHJcbiAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0ICYge1xyXG4gICAgZGF0YVNvdXJjZT86IHtcclxuICAgICAgb3BlbnNlYXJjaDoge1xyXG4gICAgICAgIGdldENsaWVudDogKGRhdGFTb3VyY2VJZDogc3RyaW5nKSA9PiBQcm9taXNlPE9wZW5TZWFyY2hDbGllbnQ+O1xyXG4gICAgICB9O1xyXG4gICAgfTtcclxuICB9O1xyXG4gIGRhdGFTb3VyY2VJZD86IHN0cmluZztcclxufSkgPT4ge1xyXG4gIGlmIChkYXRhU291cmNlSWQgJiYgY29udGV4dC5kYXRhU291cmNlKSB7XHJcbiAgICByZXR1cm4gKGF3YWl0IGNvbnRleHQuZGF0YVNvdXJjZS5vcGVuc2VhcmNoLmdldENsaWVudChkYXRhU291cmNlSWQpKS50cmFuc3BvcnQ7XHJcbiAgfVxyXG4gIHJldHVybiBjb250ZXh0LmNvcmUub3BlbnNlYXJjaC5jbGllbnQuYXNDdXJyZW50VXNlci50cmFuc3BvcnQ7XHJcbn07XHJcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBSU8sTUFBTUEsNEJBQTRCLEdBQUcsTUFBQUEsQ0FBTztFQUNqREMsT0FBTztFQUNQQztBQVVGLENBQUMsS0FBSztFQUNKLElBQUlBLFlBQVksSUFBSUQsT0FBTyxDQUFDRSxVQUFVLEVBQUU7SUFDdEMsT0FBTyxDQUFDLE1BQU1GLE9BQU8sQ0FBQ0UsVUFBVSxDQUFDQyxVQUFVLENBQUNDLFNBQVMsQ0FBQ0gsWUFBWSxDQUFDLEVBQUVJLFNBQVM7RUFDaEY7RUFDQSxPQUFPTCxPQUFPLENBQUNNLElBQUksQ0FBQ0gsVUFBVSxDQUFDSSxNQUFNLENBQUNDLGFBQWEsQ0FBQ0gsU0FBUztBQUMvRCxDQUFDO0FBQUNJLE9BQUEsQ0FBQVYsNEJBQUEsR0FBQUEsNEJBQUEifQ==