"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatInteractionFromBackend = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Agent framework changes interaction_id to message_id
 * In FE we need to change this back.
 */
const formatInteractionFromBackend = interaction => {
  const {
    message_id: messageId,
    memory_id: memoryId,
    ...others
  } = interaction || {};
  return {
    ...others,
    interaction_id: messageId || '',
    conversation_id: memoryId || ''
  };
};
exports.formatInteractionFromBackend = formatInteractionFromBackend;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJmb3JtYXRJbnRlcmFjdGlvbkZyb21CYWNrZW5kIiwiaW50ZXJhY3Rpb24iLCJtZXNzYWdlX2lkIiwibWVzc2FnZUlkIiwibWVtb3J5X2lkIiwibWVtb3J5SWQiLCJvdGhlcnMiLCJpbnRlcmFjdGlvbl9pZCIsImNvbnZlcnNhdGlvbl9pZCIsImV4cG9ydHMiXSwic291cmNlcyI6WyJmb3JtYXQudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHtcclxuICBJbnRlcmFjdGlvbixcclxuICBJbnRlcmFjdGlvbkZyb21BZ2VudEZyYW1ld29yayxcclxufSBmcm9tICcuLi8uLi9jb21tb24vdHlwZXMvY2hhdF9zYXZlZF9vYmplY3RfYXR0cmlidXRlcyc7XHJcblxyXG4vKipcclxuICogQWdlbnQgZnJhbWV3b3JrIGNoYW5nZXMgaW50ZXJhY3Rpb25faWQgdG8gbWVzc2FnZV9pZFxyXG4gKiBJbiBGRSB3ZSBuZWVkIHRvIGNoYW5nZSB0aGlzIGJhY2suXHJcbiAqL1xyXG5leHBvcnQgY29uc3QgZm9ybWF0SW50ZXJhY3Rpb25Gcm9tQmFja2VuZCA9IChcclxuICBpbnRlcmFjdGlvbjogSW50ZXJhY3Rpb25Gcm9tQWdlbnRGcmFtZXdvcmtcclxuKTogSW50ZXJhY3Rpb24gPT4ge1xyXG4gIGNvbnN0IHsgbWVzc2FnZV9pZDogbWVzc2FnZUlkLCBtZW1vcnlfaWQ6IG1lbW9yeUlkLCAuLi5vdGhlcnMgfSA9IGludGVyYWN0aW9uIHx8IHt9O1xyXG4gIHJldHVybiB7XHJcbiAgICAuLi5vdGhlcnMsXHJcbiAgICBpbnRlcmFjdGlvbl9pZDogbWVzc2FnZUlkIHx8ICcnLFxyXG4gICAgY29udmVyc2F0aW9uX2lkOiBtZW1vcnlJZCB8fCAnJyxcclxuICB9O1xyXG59O1xyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQU9BO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTUEsNEJBQTRCLEdBQ3ZDQyxXQUEwQyxJQUMxQjtFQUNoQixNQUFNO0lBQUVDLFVBQVUsRUFBRUMsU0FBUztJQUFFQyxTQUFTLEVBQUVDLFFBQVE7SUFBRSxHQUFHQztFQUFPLENBQUMsR0FBR0wsV0FBVyxJQUFJLENBQUMsQ0FBQztFQUNuRixPQUFPO0lBQ0wsR0FBR0ssTUFBTTtJQUNUQyxjQUFjLEVBQUVKLFNBQVMsSUFBSSxFQUFFO0lBQy9CSyxlQUFlLEVBQUVILFFBQVEsSUFBSTtFQUMvQixDQUFDO0FBQ0gsQ0FBQztBQUFDSSxPQUFBLENBQUFULDRCQUFBLEdBQUFBLDRCQUFBIn0=