"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJsonFromString = void 0;
var _stream = require("stream");
var _csvParser = _interopRequireDefault(require("csv-parser"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getJsonFromString = (csvString, options) => {
  const results = [];
  return new Promise((resolve, reject) => {
    _stream.Readable.from(csvString).pipe((0, _csvParser.default)(options)).on('data', data => results.push(data)).on('end', () => {
      resolve(results);
    }).on('error', err => {
      reject(err);
    });
  });
};
exports.getJsonFromString = getJsonFromString;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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