"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LRUCache = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Doubly linked list node

// LRU Cache with a size limit using doubly linked list
class LRUCache {
  // Maximum cache size

  constructor(maxSize) {
    _defineProperty(this, "cache", new Map());
    // Stores key-to-node mapping
    _defineProperty(this, "head", null);
    // Head of the doubly linked list (LRU end)
    _defineProperty(this, "tail", null);
    // Tail of the doubly linked list (MRU end)
    _defineProperty(this, "maxSize", void 0);
    this.maxSize = maxSize;
  }

  // Get the entire cache in the LRU order
  getAllCache() {
    const result = [];
    let current = this.head;
    while (current) {
      result.push({
        key: current.key,
        value: current.value
      });
      current = current.next;
    }
    return result;
  }

  // Print internal cache for debug
  print() {
    let current = this.head;
    while (current) {
      console.log(`Key: ${current.key}, Value: ${current.value}`);
      current = current.next;
    }
  }

  // Get data from cache by cacheKey and update LRU order
  getCache(cacheKey) {
    if (this.cache.has(cacheKey)) {
      const node = this.cache.get(cacheKey);
      if (node) {
        this.moveToEnd(node);
        return node.value;
      }
    }
    return null;
  }

  // Set data in cache for a specific cacheKey
  setCache(cacheKey, data) {
    if (this.cache.has(cacheKey)) {
      const node = this.cache.get(cacheKey);
      if (node) {
        node.value = data;
        this.moveToEnd(node);
      }
    } else {
      if (this.cache.size >= this.maxSize) {
        this.evict();
      }
      const newNode = this.createNode(cacheKey, data);
      this.cache.set(cacheKey, newNode);
      this.addToTail(newNode);
    }
  }

  // Clear data from cache for a specific cacheKey
  clearCache(cacheKey) {
    const node = this.cache.get(cacheKey);
    if (node) {
      this.cache.delete(cacheKey);
      this.removeNode(node);
    }
  }

  // Clear all data from the cache
  clearAllCache() {
    this.cache.clear();
    this.head = this.tail = null;
  }

  // Create a ListNode instance
  createNode(key, value) {
    return {
      key,
      value,
      prev: null,
      next: null
    };
  }

  // Add a node to the tail (MRU)
  addToTail(node) {
    if (!this.tail) {
      this.head = this.tail = node;
    } else {
      this.tail.next = node;
      node.prev = this.tail;
      this.tail = node;
    }
  }

  // Move a node to the tail (most recently used)
  moveToEnd(node) {
    if (node === this.tail) return;
    this.removeNode(node);
    this.addToTail(node);
  }

  // Remove a node from the doubly linked list
  removeNode(node) {
    if (node.prev) node.prev.next = node.next;
    if (node.next) node.next.prev = node.prev;
    if (node === this.head) this.head = node.next;
    if (node === this.tail) this.tail = node.prev;
    node.prev = node.next = null;
  }

  // Evict the least recently used item (head of the list)
  evict() {
    if (this.head) {
      const evictKey = this.head.key;
      this.cache.delete(evictKey);
      this.removeNode(this.head);
    }
  }
}
exports.LRUCache = LRUCache;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJMUlVDYWNoZSIsImNvbnN0cnVjdG9yIiwibWF4U2l6ZSIsIl9kZWZpbmVQcm9wZXJ0eSIsIk1hcCIsImdldEFsbENhY2hlIiwicmVzdWx0IiwiY3VycmVudCIsImhlYWQiLCJwdXNoIiwia2V5IiwidmFsdWUiLCJuZXh0IiwicHJpbnQiLCJjb25zb2xlIiwibG9nIiwiZ2V0Q2FjaGUiLCJjYWNoZUtleSIsImNhY2hlIiwiaGFzIiwibm9kZSIsImdldCIsIm1vdmVUb0VuZCIsInNldENhY2hlIiwiZGF0YSIsInNpemUiLCJldmljdCIsIm5ld05vZGUiLCJjcmVhdGVOb2RlIiwic2V0IiwiYWRkVG9UYWlsIiwiY2xlYXJDYWNoZSIsImRlbGV0ZSIsInJlbW92ZU5vZGUiLCJjbGVhckFsbENhY2hlIiwiY2xlYXIiLCJ0YWlsIiwicHJldiIsImV2aWN0S2V5IiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbImNhY2hlX3V0aWwudHN4Il0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbi8vIERvdWJseSBsaW5rZWQgbGlzdCBub2RlXHJcbmludGVyZmFjZSBMaXN0Tm9kZTxLLCBWPiB7XHJcbiAga2V5OiBLOyAvLyBDYWNoZSBrZXlcclxuICB2YWx1ZTogVjsgLy8gQ2FjaGUgZGF0YVxyXG4gIHByZXY6IExpc3ROb2RlPEssIFY+IHwgbnVsbDsgLy8gUHJldmlvdXMgbm9kZVxyXG4gIG5leHQ6IExpc3ROb2RlPEssIFY+IHwgbnVsbDsgLy8gTmV4dCBub2RlXHJcbn1cclxuXHJcbi8vIExSVSBDYWNoZSB3aXRoIGEgc2l6ZSBsaW1pdCB1c2luZyBkb3VibHkgbGlua2VkIGxpc3RcclxuZXhwb3J0IGNsYXNzIExSVUNhY2hlPEssIFY+IHtcclxuICBwcml2YXRlIGNhY2hlOiBNYXA8SywgTGlzdE5vZGU8SywgVj4+ID0gbmV3IE1hcCgpOyAvLyBTdG9yZXMga2V5LXRvLW5vZGUgbWFwcGluZ1xyXG4gIHByaXZhdGUgaGVhZDogTGlzdE5vZGU8SywgVj4gfCBudWxsID0gbnVsbDsgLy8gSGVhZCBvZiB0aGUgZG91Ymx5IGxpbmtlZCBsaXN0IChMUlUgZW5kKVxyXG4gIHByaXZhdGUgdGFpbDogTGlzdE5vZGU8SywgVj4gfCBudWxsID0gbnVsbDsgLy8gVGFpbCBvZiB0aGUgZG91Ymx5IGxpbmtlZCBsaXN0IChNUlUgZW5kKVxyXG4gIHByaXZhdGUgbWF4U2l6ZTogbnVtYmVyOyAvLyBNYXhpbXVtIGNhY2hlIHNpemVcclxuXHJcbiAgY29uc3RydWN0b3IobWF4U2l6ZTogbnVtYmVyKSB7XHJcbiAgICB0aGlzLm1heFNpemUgPSBtYXhTaXplO1xyXG4gIH1cclxuXHJcbiAgLy8gR2V0IHRoZSBlbnRpcmUgY2FjaGUgaW4gdGhlIExSVSBvcmRlclxyXG4gIHB1YmxpYyBnZXRBbGxDYWNoZSgpOiBBcnJheTx7IGtleTogSzsgdmFsdWU6IFYgfT4ge1xyXG4gICAgY29uc3QgcmVzdWx0OiBBcnJheTx7IGtleTogSzsgdmFsdWU6IFYgfT4gPSBbXTtcclxuICAgIGxldCBjdXJyZW50ID0gdGhpcy5oZWFkO1xyXG5cclxuICAgIHdoaWxlIChjdXJyZW50KSB7XHJcbiAgICAgIHJlc3VsdC5wdXNoKHsga2V5OiBjdXJyZW50LmtleSwgdmFsdWU6IGN1cnJlbnQudmFsdWUgfSk7XHJcbiAgICAgIGN1cnJlbnQgPSBjdXJyZW50Lm5leHQ7XHJcbiAgICB9XHJcblxyXG4gICAgcmV0dXJuIHJlc3VsdDtcclxuICB9XHJcblxyXG4gIC8vIFByaW50IGludGVybmFsIGNhY2hlIGZvciBkZWJ1Z1xyXG4gIHB1YmxpYyBwcmludCgpIHtcclxuICAgIGxldCBjdXJyZW50ID0gdGhpcy5oZWFkO1xyXG4gICAgd2hpbGUgKGN1cnJlbnQpIHtcclxuICAgICAgY29uc29sZS5sb2coYEtleTogJHtjdXJyZW50LmtleX0sIFZhbHVlOiAke2N1cnJlbnQudmFsdWV9YCk7XHJcbiAgICAgIGN1cnJlbnQgPSBjdXJyZW50Lm5leHQ7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICAvLyBHZXQgZGF0YSBmcm9tIGNhY2hlIGJ5IGNhY2hlS2V5IGFuZCB1cGRhdGUgTFJVIG9yZGVyXHJcbiAgcHVibGljIGdldENhY2hlKGNhY2hlS2V5OiBLKTogViB8IG51bGwge1xyXG4gICAgaWYgKHRoaXMuY2FjaGUuaGFzKGNhY2hlS2V5KSkge1xyXG4gICAgICBjb25zdCBub2RlID0gdGhpcy5jYWNoZS5nZXQoY2FjaGVLZXkpO1xyXG4gICAgICBpZiAobm9kZSkge1xyXG4gICAgICAgIHRoaXMubW92ZVRvRW5kKG5vZGUpO1xyXG4gICAgICAgIHJldHVybiBub2RlLnZhbHVlO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgICByZXR1cm4gbnVsbDtcclxuICB9XHJcblxyXG4gIC8vIFNldCBkYXRhIGluIGNhY2hlIGZvciBhIHNwZWNpZmljIGNhY2hlS2V5XHJcbiAgcHVibGljIHNldENhY2hlKGNhY2hlS2V5OiBLLCBkYXRhOiBWKTogdm9pZCB7XHJcbiAgICBpZiAodGhpcy5jYWNoZS5oYXMoY2FjaGVLZXkpKSB7XHJcbiAgICAgIGNvbnN0IG5vZGUgPSB0aGlzLmNhY2hlLmdldChjYWNoZUtleSk7XHJcbiAgICAgIGlmIChub2RlKSB7XHJcbiAgICAgICAgbm9kZS52YWx1ZSA9IGRhdGE7XHJcbiAgICAgICAgdGhpcy5tb3ZlVG9FbmQobm9kZSk7XHJcbiAgICAgIH1cclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIGlmICh0aGlzLmNhY2hlLnNpemUgPj0gdGhpcy5tYXhTaXplKSB7XHJcbiAgICAgICAgdGhpcy5ldmljdCgpO1xyXG4gICAgICB9XHJcbiAgICAgIGNvbnN0IG5ld05vZGUgPSB0aGlzLmNyZWF0ZU5vZGUoY2FjaGVLZXksIGRhdGEpO1xyXG4gICAgICB0aGlzLmNhY2hlLnNldChjYWNoZUtleSwgbmV3Tm9kZSk7XHJcbiAgICAgIHRoaXMuYWRkVG9UYWlsKG5ld05vZGUpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgLy8gQ2xlYXIgZGF0YSBmcm9tIGNhY2hlIGZvciBhIHNwZWNpZmljIGNhY2hlS2V5XHJcbiAgcHVibGljIGNsZWFyQ2FjaGUoY2FjaGVLZXk6IEspOiB2b2lkIHtcclxuICAgIGNvbnN0IG5vZGUgPSB0aGlzLmNhY2hlLmdldChjYWNoZUtleSk7XHJcbiAgICBpZiAobm9kZSkge1xyXG4gICAgICB0aGlzLmNhY2hlLmRlbGV0ZShjYWNoZUtleSk7XHJcbiAgICAgIHRoaXMucmVtb3ZlTm9kZShub2RlKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIC8vIENsZWFyIGFsbCBkYXRhIGZyb20gdGhlIGNhY2hlXHJcbiAgcHVibGljIGNsZWFyQWxsQ2FjaGUoKTogdm9pZCB7XHJcbiAgICB0aGlzLmNhY2hlLmNsZWFyKCk7XHJcbiAgICB0aGlzLmhlYWQgPSB0aGlzLnRhaWwgPSBudWxsO1xyXG4gIH1cclxuXHJcbiAgLy8gQ3JlYXRlIGEgTGlzdE5vZGUgaW5zdGFuY2VcclxuICBwcml2YXRlIGNyZWF0ZU5vZGUoa2V5OiBLLCB2YWx1ZTogVik6IExpc3ROb2RlPEssIFY+IHtcclxuICAgIHJldHVybiB7XHJcbiAgICAgIGtleSxcclxuICAgICAgdmFsdWUsXHJcbiAgICAgIHByZXY6IG51bGwsXHJcbiAgICAgIG5leHQ6IG51bGwsXHJcbiAgICB9O1xyXG4gIH1cclxuXHJcbiAgLy8gQWRkIGEgbm9kZSB0byB0aGUgdGFpbCAoTVJVKVxyXG4gIHByaXZhdGUgYWRkVG9UYWlsKG5vZGU6IExpc3ROb2RlPEssIFY+KTogdm9pZCB7XHJcbiAgICBpZiAoIXRoaXMudGFpbCkge1xyXG4gICAgICB0aGlzLmhlYWQgPSB0aGlzLnRhaWwgPSBub2RlO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgdGhpcy50YWlsLm5leHQgPSBub2RlO1xyXG4gICAgICBub2RlLnByZXYgPSB0aGlzLnRhaWw7XHJcbiAgICAgIHRoaXMudGFpbCA9IG5vZGU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICAvLyBNb3ZlIGEgbm9kZSB0byB0aGUgdGFpbCAobW9zdCByZWNlbnRseSB1c2VkKVxyXG4gIHByaXZhdGUgbW92ZVRvRW5kKG5vZGU6IExpc3ROb2RlPEssIFY+KTogdm9pZCB7XHJcbiAgICBpZiAobm9kZSA9PT0gdGhpcy50YWlsKSByZXR1cm47XHJcblxyXG4gICAgdGhpcy5yZW1vdmVOb2RlKG5vZGUpO1xyXG4gICAgdGhpcy5hZGRUb1RhaWwobm9kZSk7XHJcbiAgfVxyXG5cclxuICAvLyBSZW1vdmUgYSBub2RlIGZyb20gdGhlIGRvdWJseSBsaW5rZWQgbGlzdFxyXG4gIHByaXZhdGUgcmVtb3ZlTm9kZShub2RlOiBMaXN0Tm9kZTxLLCBWPik6IHZvaWQge1xyXG4gICAgaWYgKG5vZGUucHJldikgbm9kZS5wcmV2Lm5leHQgPSBub2RlLm5leHQ7XHJcbiAgICBpZiAobm9kZS5uZXh0KSBub2RlLm5leHQucHJldiA9IG5vZGUucHJldjtcclxuXHJcbiAgICBpZiAobm9kZSA9PT0gdGhpcy5oZWFkKSB0aGlzLmhlYWQgPSBub2RlLm5leHQ7XHJcbiAgICBpZiAobm9kZSA9PT0gdGhpcy50YWlsKSB0aGlzLnRhaWwgPSBub2RlLnByZXY7XHJcblxyXG4gICAgbm9kZS5wcmV2ID0gbm9kZS5uZXh0ID0gbnVsbDtcclxuICB9XHJcblxyXG4gIC8vIEV2aWN0IHRoZSBsZWFzdCByZWNlbnRseSB1c2VkIGl0ZW0gKGhlYWQgb2YgdGhlIGxpc3QpXHJcbiAgcHJpdmF0ZSBldmljdCgpOiB2b2lkIHtcclxuICAgIGlmICh0aGlzLmhlYWQpIHtcclxuICAgICAgY29uc3QgZXZpY3RLZXkgPSB0aGlzLmhlYWQua2V5O1xyXG4gICAgICB0aGlzLmNhY2hlLmRlbGV0ZShldmljdEtleSk7XHJcbiAgICAgIHRoaXMucmVtb3ZlTm9kZSh0aGlzLmhlYWQpO1xyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQUVBOztBQVFBO0FBQ08sTUFBTUEsUUFBUSxDQUFPO0VBSUQ7O0VBRXpCQyxXQUFXQSxDQUFDQyxPQUFlLEVBQUU7SUFBQUMsZUFBQSxnQkFMVyxJQUFJQyxHQUFHLENBQUMsQ0FBQztJQUFFO0lBQUFELGVBQUEsZUFDYixJQUFJO0lBQUU7SUFBQUEsZUFBQSxlQUNOLElBQUk7SUFBRTtJQUFBQSxlQUFBO0lBSTFDLElBQUksQ0FBQ0QsT0FBTyxHQUFHQSxPQUFPO0VBQ3hCOztFQUVBO0VBQ09HLFdBQVdBLENBQUEsRUFBZ0M7SUFDaEQsTUFBTUMsTUFBbUMsR0FBRyxFQUFFO0lBQzlDLElBQUlDLE9BQU8sR0FBRyxJQUFJLENBQUNDLElBQUk7SUFFdkIsT0FBT0QsT0FBTyxFQUFFO01BQ2RELE1BQU0sQ0FBQ0csSUFBSSxDQUFDO1FBQUVDLEdBQUcsRUFBRUgsT0FBTyxDQUFDRyxHQUFHO1FBQUVDLEtBQUssRUFBRUosT0FBTyxDQUFDSTtNQUFNLENBQUMsQ0FBQztNQUN2REosT0FBTyxHQUFHQSxPQUFPLENBQUNLLElBQUk7SUFDeEI7SUFFQSxPQUFPTixNQUFNO0VBQ2Y7O0VBRUE7RUFDT08sS0FBS0EsQ0FBQSxFQUFHO0lBQ2IsSUFBSU4sT0FBTyxHQUFHLElBQUksQ0FBQ0MsSUFBSTtJQUN2QixPQUFPRCxPQUFPLEVBQUU7TUFDZE8sT0FBTyxDQUFDQyxHQUFHLENBQUUsUUFBT1IsT0FBTyxDQUFDRyxHQUFJLFlBQVdILE9BQU8sQ0FBQ0ksS0FBTSxFQUFDLENBQUM7TUFDM0RKLE9BQU8sR0FBR0EsT0FBTyxDQUFDSyxJQUFJO0lBQ3hCO0VBQ0Y7O0VBRUE7RUFDT0ksUUFBUUEsQ0FBQ0MsUUFBVyxFQUFZO0lBQ3JDLElBQUksSUFBSSxDQUFDQyxLQUFLLENBQUNDLEdBQUcsQ0FBQ0YsUUFBUSxDQUFDLEVBQUU7TUFDNUIsTUFBTUcsSUFBSSxHQUFHLElBQUksQ0FBQ0YsS0FBSyxDQUFDRyxHQUFHLENBQUNKLFFBQVEsQ0FBQztNQUNyQyxJQUFJRyxJQUFJLEVBQUU7UUFDUixJQUFJLENBQUNFLFNBQVMsQ0FBQ0YsSUFBSSxDQUFDO1FBQ3BCLE9BQU9BLElBQUksQ0FBQ1QsS0FBSztNQUNuQjtJQUNGO0lBQ0EsT0FBTyxJQUFJO0VBQ2I7O0VBRUE7RUFDT1ksUUFBUUEsQ0FBQ04sUUFBVyxFQUFFTyxJQUFPLEVBQVE7SUFDMUMsSUFBSSxJQUFJLENBQUNOLEtBQUssQ0FBQ0MsR0FBRyxDQUFDRixRQUFRLENBQUMsRUFBRTtNQUM1QixNQUFNRyxJQUFJLEdBQUcsSUFBSSxDQUFDRixLQUFLLENBQUNHLEdBQUcsQ0FBQ0osUUFBUSxDQUFDO01BQ3JDLElBQUlHLElBQUksRUFBRTtRQUNSQSxJQUFJLENBQUNULEtBQUssR0FBR2EsSUFBSTtRQUNqQixJQUFJLENBQUNGLFNBQVMsQ0FBQ0YsSUFBSSxDQUFDO01BQ3RCO0lBQ0YsQ0FBQyxNQUFNO01BQ0wsSUFBSSxJQUFJLENBQUNGLEtBQUssQ0FBQ08sSUFBSSxJQUFJLElBQUksQ0FBQ3ZCLE9BQU8sRUFBRTtRQUNuQyxJQUFJLENBQUN3QixLQUFLLENBQUMsQ0FBQztNQUNkO01BQ0EsTUFBTUMsT0FBTyxHQUFHLElBQUksQ0FBQ0MsVUFBVSxDQUFDWCxRQUFRLEVBQUVPLElBQUksQ0FBQztNQUMvQyxJQUFJLENBQUNOLEtBQUssQ0FBQ1csR0FBRyxDQUFDWixRQUFRLEVBQUVVLE9BQU8sQ0FBQztNQUNqQyxJQUFJLENBQUNHLFNBQVMsQ0FBQ0gsT0FBTyxDQUFDO0lBQ3pCO0VBQ0Y7O0VBRUE7RUFDT0ksVUFBVUEsQ0FBQ2QsUUFBVyxFQUFRO0lBQ25DLE1BQU1HLElBQUksR0FBRyxJQUFJLENBQUNGLEtBQUssQ0FBQ0csR0FBRyxDQUFDSixRQUFRLENBQUM7SUFDckMsSUFBSUcsSUFBSSxFQUFFO01BQ1IsSUFBSSxDQUFDRixLQUFLLENBQUNjLE1BQU0sQ0FBQ2YsUUFBUSxDQUFDO01BQzNCLElBQUksQ0FBQ2dCLFVBQVUsQ0FBQ2IsSUFBSSxDQUFDO0lBQ3ZCO0VBQ0Y7O0VBRUE7RUFDT2MsYUFBYUEsQ0FBQSxFQUFTO0lBQzNCLElBQUksQ0FBQ2hCLEtBQUssQ0FBQ2lCLEtBQUssQ0FBQyxDQUFDO0lBQ2xCLElBQUksQ0FBQzNCLElBQUksR0FBRyxJQUFJLENBQUM0QixJQUFJLEdBQUcsSUFBSTtFQUM5Qjs7RUFFQTtFQUNRUixVQUFVQSxDQUFDbEIsR0FBTSxFQUFFQyxLQUFRLEVBQWtCO0lBQ25ELE9BQU87TUFDTEQsR0FBRztNQUNIQyxLQUFLO01BQ0wwQixJQUFJLEVBQUUsSUFBSTtNQUNWekIsSUFBSSxFQUFFO0lBQ1IsQ0FBQztFQUNIOztFQUVBO0VBQ1FrQixTQUFTQSxDQUFDVixJQUFvQixFQUFRO0lBQzVDLElBQUksQ0FBQyxJQUFJLENBQUNnQixJQUFJLEVBQUU7TUFDZCxJQUFJLENBQUM1QixJQUFJLEdBQUcsSUFBSSxDQUFDNEIsSUFBSSxHQUFHaEIsSUFBSTtJQUM5QixDQUFDLE1BQU07TUFDTCxJQUFJLENBQUNnQixJQUFJLENBQUN4QixJQUFJLEdBQUdRLElBQUk7TUFDckJBLElBQUksQ0FBQ2lCLElBQUksR0FBRyxJQUFJLENBQUNELElBQUk7TUFDckIsSUFBSSxDQUFDQSxJQUFJLEdBQUdoQixJQUFJO0lBQ2xCO0VBQ0Y7O0VBRUE7RUFDUUUsU0FBU0EsQ0FBQ0YsSUFBb0IsRUFBUTtJQUM1QyxJQUFJQSxJQUFJLEtBQUssSUFBSSxDQUFDZ0IsSUFBSSxFQUFFO0lBRXhCLElBQUksQ0FBQ0gsVUFBVSxDQUFDYixJQUFJLENBQUM7SUFDckIsSUFBSSxDQUFDVSxTQUFTLENBQUNWLElBQUksQ0FBQztFQUN0Qjs7RUFFQTtFQUNRYSxVQUFVQSxDQUFDYixJQUFvQixFQUFRO0lBQzdDLElBQUlBLElBQUksQ0FBQ2lCLElBQUksRUFBRWpCLElBQUksQ0FBQ2lCLElBQUksQ0FBQ3pCLElBQUksR0FBR1EsSUFBSSxDQUFDUixJQUFJO0lBQ3pDLElBQUlRLElBQUksQ0FBQ1IsSUFBSSxFQUFFUSxJQUFJLENBQUNSLElBQUksQ0FBQ3lCLElBQUksR0FBR2pCLElBQUksQ0FBQ2lCLElBQUk7SUFFekMsSUFBSWpCLElBQUksS0FBSyxJQUFJLENBQUNaLElBQUksRUFBRSxJQUFJLENBQUNBLElBQUksR0FBR1ksSUFBSSxDQUFDUixJQUFJO0lBQzdDLElBQUlRLElBQUksS0FBSyxJQUFJLENBQUNnQixJQUFJLEVBQUUsSUFBSSxDQUFDQSxJQUFJLEdBQUdoQixJQUFJLENBQUNpQixJQUFJO0lBRTdDakIsSUFBSSxDQUFDaUIsSUFBSSxHQUFHakIsSUFBSSxDQUFDUixJQUFJLEdBQUcsSUFBSTtFQUM5Qjs7RUFFQTtFQUNRYyxLQUFLQSxDQUFBLEVBQVM7SUFDcEIsSUFBSSxJQUFJLENBQUNsQixJQUFJLEVBQUU7TUFDYixNQUFNOEIsUUFBUSxHQUFHLElBQUksQ0FBQzlCLElBQUksQ0FBQ0UsR0FBRztNQUM5QixJQUFJLENBQUNRLEtBQUssQ0FBQ2MsTUFBTSxDQUFDTSxRQUFRLENBQUM7TUFDM0IsSUFBSSxDQUFDTCxVQUFVLENBQUMsSUFBSSxDQUFDekIsSUFBSSxDQUFDO0lBQzVCO0VBQ0Y7QUFDRjtBQUFDK0IsT0FBQSxDQUFBdkMsUUFBQSxHQUFBQSxRQUFBIn0=