"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OllyChatService = void 0;
var _constants = require("../../utils/constants");
var _get_agent = require("../../routes/get_agent");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const MEMORY_ID_FIELD = 'memory_id';
const INTERACTION_ID_FIELDS = ['parent_message_id', 'parent_interaction_id'];
class OllyChatService {
  constructor(opensearchClientTransport) {
    this.opensearchClientTransport = opensearchClientTransport;
  }
  async getRootAgent() {
    return await (0, _get_agent.getAgentIdByConfigName)(_constants.ROOT_AGENT_CONFIG_ID, this.opensearchClientTransport);
  }
  async requestAgentRun(payload) {
    if (payload.memory_id) {
      OllyChatService.abortControllers.set(payload.memory_id, new AbortController());
    }
    const rootAgentId = await this.getRootAgent();
    return await this.callExecuteAgentAPI(payload, rootAgentId);
  }
  async callExecuteAgentAPI(payload, rootAgentId) {
    try {
      var _agentFrameworkRespon;
      const agentFrameworkResponse = await this.opensearchClientTransport.request({
        method: 'POST',
        path: `${_constants.ML_COMMONS_BASE_API}/agents/${rootAgentId}/_execute`,
        body: {
          parameters: payload
        }
      }, {
        /**
         * It is time-consuming for LLM to generate final answer
         * Give it a large timeout window
         */
        requestTimeout: 5 * 60 * 1000,
        /**
         * Do not retry
         */
        maxRetries: 0
      });
      const outputBody = (_agentFrameworkRespon = agentFrameworkResponse.body.inference_results) === null || _agentFrameworkRespon === void 0 || (_agentFrameworkRespon = _agentFrameworkRespon[0]) === null || _agentFrameworkRespon === void 0 ? void 0 : _agentFrameworkRespon.output;
      const conversationIdItem = outputBody === null || outputBody === void 0 ? void 0 : outputBody.find(item => item.name === MEMORY_ID_FIELD);
      const interactionIdItem = outputBody === null || outputBody === void 0 ? void 0 : outputBody.find(item => INTERACTION_ID_FIELDS.includes(item.name));
      return {
        /**
         * Interactions will be stored in Agent framework,
         * thus we do not need to return the latest message back.
         */
        messages: [],
        conversationId: (conversationIdItem === null || conversationIdItem === void 0 ? void 0 : conversationIdItem.result) || '',
        interactionId: (interactionIdItem === null || interactionIdItem === void 0 ? void 0 : interactionIdItem.result) || ''
      };
    } catch (error) {
      throw error;
    } finally {
      if (payload.memory_id) {
        OllyChatService.abortControllers.delete(payload.memory_id);
      }
    }
  }
  async requestLLM(payload) {
    var _input$context;
    const {
      input,
      conversationId
    } = payload;
    let llmInput = input.content;
    if ((_input$context = input.context) !== null && _input$context !== void 0 && _input$context.content) {
      var _input$context2;
      llmInput = `Based on the context: ${(_input$context2 = input.context) === null || _input$context2 === void 0 ? void 0 : _input$context2.content}, answer question: ${input.content}`;
    }
    const parametersPayload = {
      question: llmInput,
      verbose: false
    };
    if (input.promptPrefix) {
      parametersPayload['prompt.prefix'] = input.promptPrefix;
    }
    if (conversationId) {
      parametersPayload.memory_id = conversationId;
    }
    return await this.requestAgentRun(parametersPayload);
  }
  async regenerate(payload) {
    const {
      conversationId,
      interactionId
    } = payload;
    const parametersPayload = {
      memory_id: conversationId,
      regenerate_interaction_id: interactionId,
      verbose: false
    };
    return await this.requestAgentRun(parametersPayload);
  }
  abortAgentExecution(conversationId) {
    if (OllyChatService.abortControllers.has(conversationId)) {
      var _OllyChatService$abor;
      (_OllyChatService$abor = OllyChatService.abortControllers.get(conversationId)) === null || _OllyChatService$abor === void 0 || _OllyChatService$abor.abort();
    }
  }
}
exports.OllyChatService = OllyChatService;
_defineProperty(OllyChatService, "abortControllers", new Map());
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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