"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantClient = void 0;
var _constants = require("../utils/constants");
var _get_agent = require("../routes/get_agent");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const isDataSourceQuery = query => {
  if ('dataSourceId' in query && query.dataSourceId) {
    return true;
  }
  return false;
};
class AssistantClient {
  constructor(request, context) {
    this.request = request;
    this.context = context;
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "executeAgent", async (agentId, parameters) => {
      const client = await this.getOpenSearchClient();
      const response = await client.transport.request({
        method: 'POST',
        path: `${_constants.ML_COMMONS_BASE_API}/agents/${agentId}/_execute`,
        body: {
          parameters
        }
      });
      return response;
    });
    _defineProperty(this, "executeAgentByConfigName", async (agentConfigName, parameters) => {
      const agentId = await this.getAgentIdByConfigName(agentConfigName);
      return this.executeAgent(agentId, parameters);
    });
    _defineProperty(this, "getAgentIdByConfigName", async agentConfigName => {
      const client = await this.getOpenSearchClient();
      const agentId = await (0, _get_agent.getAgentIdByConfigName)(agentConfigName, client.transport);
      return agentId;
    });
  }
  async getOpenSearchClient() {
    if (!this.client) {
      let client = this.context.core.opensearch.client.asCurrentUser;
      if (isDataSourceQuery(this.request.query) && this.context.dataSource) {
        client = await this.context.dataSource.opensearch.getClient(this.request.query.dataSourceId);
      }
      this.client = client;
    }
    return this.client;
  }
}
exports.AssistantClient = AssistantClient;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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