"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detectIndexType = detectIndexType;
var _lodash = require("lodash");
var _index_cache = require("./index_cache");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const INDEX_TYPE_DETECT_AGENT_CONFIG_ID = 'os_index_type_detect';
async function searchQuery(client, path, method, query) {
  return await client.request({
    path,
    method,
    body: query
  });
}
async function searchSampleData(client, indexName) {
  const query = {
    size: 5,
    query: {
      match_all: {}
    }
  };
  const response = await searchQuery(client, `/${encodeURIComponent(indexName)}/_search`, 'POST', query);
  const sourceArray = response.body.hits.hits.map(hit => hit._source);
  return sourceArray;
}
async function searchIndexMapping(client, indexName) {
  const response = await searchQuery(client, `/${encodeURIComponent(indexName)}/_mapping`, 'GET', undefined);
  return response.body;
}
async function detectIndexType(client, assistantClient, indexName, dataSourceId) {
  const indexCache = (0, _index_cache.getIndexCache)(indexName, dataSourceId ? dataSourceId : '');
  if (indexCache) {
    return indexCache.isLogRelated;
  }
  try {
    const indexMapping = (0, _lodash.escape)(JSON.stringify(await searchIndexMapping(client, indexName)));
    const sampleData = (0, _lodash.escape)(JSON.stringify(await searchSampleData(client, indexName)));
    const response = await assistantClient.executeAgentByConfigName(INDEX_TYPE_DETECT_AGENT_CONFIG_ID, {
      sampleData,
      schema: indexMapping
    });
    const detectResult = JSON.parse(response.body.inference_results[0].output[0].result);
    if (detectResult) {
      (0, _index_cache.setIndexCache)(new _index_cache.IndexCacheData(detectResult.isRelated, detectResult.reason), indexName, dataSourceId ? dataSourceId : '');
      return detectResult.isRelated;
    }
    return false;
  } catch (error) {
    console.error('Error detecting index type:', error.body || error.message);
    // Can not detect index type and return default as is not log related
    return false;
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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