"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setIndexCache = exports.getIndexCache = exports.getAllIndexCache = exports.clearIndexCache = exports.clearAllIndexCache = exports.IndexCacheData = void 0;
var _crypto = require("crypto");
var _cache_util = require("../utils/cache_util");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const indexCacheSize = 1000;

// Cache to store the data for checking the index is log-related or not.
class IndexCacheData {
  static generateCacheKey(indexName, dataSourceId) {
    const combinedString = `${dataSourceId}-${indexName}`;
    return (0, _crypto.createHash)('sha256').update(combinedString).digest('hex');
  }
  constructor(isLogRelated, reason) {
    _defineProperty(this, "isLogRelated", void 0);
    _defineProperty(this, "reason", void 0);
    this.isLogRelated = isLogRelated;
    this.reason = reason;
  }
}

// Create an instance of LRUCache for IndexCacheData.
exports.IndexCacheData = IndexCacheData;
const indexLRUCache = new _cache_util.LRUCache(indexCacheSize);
const getIndexCache = (indexName, dataSourceId) => {
  return indexLRUCache.getCache(IndexCacheData.generateCacheKey(indexName, dataSourceId));
};
exports.getIndexCache = getIndexCache;
const setIndexCache = (data, indexName, dataSourceId) => {
  return indexLRUCache.setCache(IndexCacheData.generateCacheKey(indexName, dataSourceId), data);
};
exports.setIndexCache = setIndexCache;
const getAllIndexCache = () => {
  return indexLRUCache.getAllCache();
};
exports.getAllIndexCache = getAllIndexCache;
const clearIndexCache = (indexName, dataSourceId) => {
  return indexLRUCache.clearCache(IndexCacheData.generateCacheKey(indexName, dataSourceId));
};
exports.clearIndexCache = clearIndexCache;
const clearAllIndexCache = () => {
  return indexLRUCache.clearAllCache();
};
exports.clearAllIndexCache = clearAllIndexCache;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY3J5cHRvIiwicmVxdWlyZSIsIl9jYWNoZV91dGlsIiwiX2RlZmluZVByb3BlcnR5IiwiZSIsInIiLCJ0IiwiX3RvUHJvcGVydHlLZXkiLCJPYmplY3QiLCJkZWZpbmVQcm9wZXJ0eSIsInZhbHVlIiwiZW51bWVyYWJsZSIsImNvbmZpZ3VyYWJsZSIsIndyaXRhYmxlIiwiaSIsIl90b1ByaW1pdGl2ZSIsIlN5bWJvbCIsInRvUHJpbWl0aXZlIiwiY2FsbCIsIlR5cGVFcnJvciIsIlN0cmluZyIsIk51bWJlciIsImluZGV4Q2FjaGVTaXplIiwiSW5kZXhDYWNoZURhdGEiLCJnZW5lcmF0ZUNhY2hlS2V5IiwiaW5kZXhOYW1lIiwiZGF0YVNvdXJjZUlkIiwiY29tYmluZWRTdHJpbmciLCJjcmVhdGVIYXNoIiwidXBkYXRlIiwiZGlnZXN0IiwiY29uc3RydWN0b3IiLCJpc0xvZ1JlbGF0ZWQiLCJyZWFzb24iLCJleHBvcnRzIiwiaW5kZXhMUlVDYWNoZSIsIkxSVUNhY2hlIiwiZ2V0SW5kZXhDYWNoZSIsImdldENhY2hlIiwic2V0SW5kZXhDYWNoZSIsImRhdGEiLCJzZXRDYWNoZSIsImdldEFsbEluZGV4Q2FjaGUiLCJnZXRBbGxDYWNoZSIsImNsZWFySW5kZXhDYWNoZSIsImNsZWFyQ2FjaGUiLCJjbGVhckFsbEluZGV4Q2FjaGUiLCJjbGVhckFsbENhY2hlIl0sInNvdXJjZXMiOlsiaW5kZXhfY2FjaGUudHN4Il0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IGNyZWF0ZUhhc2ggfSBmcm9tICdjcnlwdG8nO1xyXG5pbXBvcnQgeyBMUlVDYWNoZSB9IGZyb20gJy4uL3V0aWxzL2NhY2hlX3V0aWwnO1xyXG5cclxuY29uc3QgaW5kZXhDYWNoZVNpemUgPSAxMDAwO1xyXG5cclxuLy8gQ2FjaGUgdG8gc3RvcmUgdGhlIGRhdGEgZm9yIGNoZWNraW5nIHRoZSBpbmRleCBpcyBsb2ctcmVsYXRlZCBvciBub3QuXHJcbmV4cG9ydCBjbGFzcyBJbmRleENhY2hlRGF0YSB7XHJcbiAgaXNMb2dSZWxhdGVkOiBib29sZWFuO1xyXG4gIHJlYXNvbjogc3RyaW5nO1xyXG5cclxuICBwdWJsaWMgc3RhdGljIGdlbmVyYXRlQ2FjaGVLZXkoaW5kZXhOYW1lOiBzdHJpbmcsIGRhdGFTb3VyY2VJZDogc3RyaW5nKTogc3RyaW5nIHtcclxuICAgIGNvbnN0IGNvbWJpbmVkU3RyaW5nID0gYCR7ZGF0YVNvdXJjZUlkfS0ke2luZGV4TmFtZX1gO1xyXG4gICAgcmV0dXJuIGNyZWF0ZUhhc2goJ3NoYTI1NicpLnVwZGF0ZShjb21iaW5lZFN0cmluZykuZGlnZXN0KCdoZXgnKTtcclxuICB9XHJcblxyXG4gIGNvbnN0cnVjdG9yKGlzTG9nUmVsYXRlZDogYm9vbGVhbiwgcmVhc29uOiBzdHJpbmcpIHtcclxuICAgIHRoaXMuaXNMb2dSZWxhdGVkID0gaXNMb2dSZWxhdGVkO1xyXG4gICAgdGhpcy5yZWFzb24gPSByZWFzb247XHJcbiAgfVxyXG59XHJcblxyXG4vLyBDcmVhdGUgYW4gaW5zdGFuY2Ugb2YgTFJVQ2FjaGUgZm9yIEluZGV4Q2FjaGVEYXRhLlxyXG5jb25zdCBpbmRleExSVUNhY2hlID0gbmV3IExSVUNhY2hlPHN0cmluZywgSW5kZXhDYWNoZURhdGE+KGluZGV4Q2FjaGVTaXplKTtcclxuXHJcbmV4cG9ydCBjb25zdCBnZXRJbmRleENhY2hlID0gKGluZGV4TmFtZTogc3RyaW5nLCBkYXRhU291cmNlSWQ6IHN0cmluZyk6IEluZGV4Q2FjaGVEYXRhIHwgbnVsbCA9PiB7XHJcbiAgcmV0dXJuIGluZGV4TFJVQ2FjaGUuZ2V0Q2FjaGUoSW5kZXhDYWNoZURhdGEuZ2VuZXJhdGVDYWNoZUtleShpbmRleE5hbWUsIGRhdGFTb3VyY2VJZCkpO1xyXG59O1xyXG5cclxuZXhwb3J0IGNvbnN0IHNldEluZGV4Q2FjaGUgPSAoXHJcbiAgZGF0YTogSW5kZXhDYWNoZURhdGEsXHJcbiAgaW5kZXhOYW1lOiBzdHJpbmcsXHJcbiAgZGF0YVNvdXJjZUlkOiBzdHJpbmdcclxuKTogdm9pZCA9PiB7XHJcbiAgcmV0dXJuIGluZGV4TFJVQ2FjaGUuc2V0Q2FjaGUoSW5kZXhDYWNoZURhdGEuZ2VuZXJhdGVDYWNoZUtleShpbmRleE5hbWUsIGRhdGFTb3VyY2VJZCksIGRhdGEpO1xyXG59O1xyXG5cclxuZXhwb3J0IGNvbnN0IGdldEFsbEluZGV4Q2FjaGUgPSAoKTogdW5rbm93biA9PiB7XHJcbiAgcmV0dXJuIGluZGV4TFJVQ2FjaGUuZ2V0QWxsQ2FjaGUoKTtcclxufTtcclxuXHJcbmV4cG9ydCBjb25zdCBjbGVhckluZGV4Q2FjaGUgPSAoaW5kZXhOYW1lOiBzdHJpbmcsIGRhdGFTb3VyY2VJZDogc3RyaW5nKTogdm9pZCA9PiB7XHJcbiAgcmV0dXJuIGluZGV4TFJVQ2FjaGUuY2xlYXJDYWNoZShJbmRleENhY2hlRGF0YS5nZW5lcmF0ZUNhY2hlS2V5KGluZGV4TmFtZSwgZGF0YVNvdXJjZUlkKSk7XHJcbn07XHJcblxyXG5leHBvcnQgY29uc3QgY2xlYXJBbGxJbmRleENhY2hlID0gKCk6IHZvaWQgPT4ge1xyXG4gIHJldHVybiBpbmRleExSVUNhY2hlLmNsZWFyQWxsQ2FjaGUoKTtcclxufTtcclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxPQUFBLEdBQUFDLE9BQUE7QUFDQSxJQUFBQyxXQUFBLEdBQUFELE9BQUE7QUFBK0MsU0FBQUUsZ0JBQUFDLENBQUEsRUFBQUMsQ0FBQSxFQUFBQyxDQUFBLFlBQUFELENBQUEsR0FBQUUsY0FBQSxDQUFBRixDQUFBLE1BQUFELENBQUEsR0FBQUksTUFBQSxDQUFBQyxjQUFBLENBQUFMLENBQUEsRUFBQUMsQ0FBQSxJQUFBSyxLQUFBLEVBQUFKLENBQUEsRUFBQUssVUFBQSxNQUFBQyxZQUFBLE1BQUFDLFFBQUEsVUFBQVQsQ0FBQSxDQUFBQyxDQUFBLElBQUFDLENBQUEsRUFBQUYsQ0FBQTtBQUFBLFNBQUFHLGVBQUFELENBQUEsUUFBQVEsQ0FBQSxHQUFBQyxZQUFBLENBQUFULENBQUEsdUNBQUFRLENBQUEsR0FBQUEsQ0FBQSxHQUFBQSxDQUFBO0FBQUEsU0FBQUMsYUFBQVQsQ0FBQSxFQUFBRCxDQUFBLDJCQUFBQyxDQUFBLEtBQUFBLENBQUEsU0FBQUEsQ0FBQSxNQUFBRixDQUFBLEdBQUFFLENBQUEsQ0FBQVUsTUFBQSxDQUFBQyxXQUFBLGtCQUFBYixDQUFBLFFBQUFVLENBQUEsR0FBQVYsQ0FBQSxDQUFBYyxJQUFBLENBQUFaLENBQUEsRUFBQUQsQ0FBQSx1Q0FBQVMsQ0FBQSxTQUFBQSxDQUFBLFlBQUFLLFNBQUEseUVBQUFkLENBQUEsR0FBQWUsTUFBQSxHQUFBQyxNQUFBLEVBQUFmLENBQUEsS0FOL0M7QUFDQTtBQUNBO0FBQ0E7QUFLQSxNQUFNZ0IsY0FBYyxHQUFHLElBQUk7O0FBRTNCO0FBQ08sTUFBTUMsY0FBYyxDQUFDO0VBSTFCLE9BQWNDLGdCQUFnQkEsQ0FBQ0MsU0FBaUIsRUFBRUMsWUFBb0IsRUFBVTtJQUM5RSxNQUFNQyxjQUFjLEdBQUksR0FBRUQsWUFBYSxJQUFHRCxTQUFVLEVBQUM7SUFDckQsT0FBTyxJQUFBRyxrQkFBVSxFQUFDLFFBQVEsQ0FBQyxDQUFDQyxNQUFNLENBQUNGLGNBQWMsQ0FBQyxDQUFDRyxNQUFNLENBQUMsS0FBSyxDQUFDO0VBQ2xFO0VBRUFDLFdBQVdBLENBQUNDLFlBQXFCLEVBQUVDLE1BQWMsRUFBRTtJQUFBOUIsZUFBQTtJQUFBQSxlQUFBO0lBQ2pELElBQUksQ0FBQzZCLFlBQVksR0FBR0EsWUFBWTtJQUNoQyxJQUFJLENBQUNDLE1BQU0sR0FBR0EsTUFBTTtFQUN0QjtBQUNGOztBQUVBO0FBQUFDLE9BQUEsQ0FBQVgsY0FBQSxHQUFBQSxjQUFBO0FBQ0EsTUFBTVksYUFBYSxHQUFHLElBQUlDLG9CQUFRLENBQXlCZCxjQUFjLENBQUM7QUFFbkUsTUFBTWUsYUFBYSxHQUFHQSxDQUFDWixTQUFpQixFQUFFQyxZQUFvQixLQUE0QjtFQUMvRixPQUFPUyxhQUFhLENBQUNHLFFBQVEsQ0FBQ2YsY0FBYyxDQUFDQyxnQkFBZ0IsQ0FBQ0MsU0FBUyxFQUFFQyxZQUFZLENBQUMsQ0FBQztBQUN6RixDQUFDO0FBQUNRLE9BQUEsQ0FBQUcsYUFBQSxHQUFBQSxhQUFBO0FBRUssTUFBTUUsYUFBYSxHQUFHQSxDQUMzQkMsSUFBb0IsRUFDcEJmLFNBQWlCLEVBQ2pCQyxZQUFvQixLQUNYO0VBQ1QsT0FBT1MsYUFBYSxDQUFDTSxRQUFRLENBQUNsQixjQUFjLENBQUNDLGdCQUFnQixDQUFDQyxTQUFTLEVBQUVDLFlBQVksQ0FBQyxFQUFFYyxJQUFJLENBQUM7QUFDL0YsQ0FBQztBQUFDTixPQUFBLENBQUFLLGFBQUEsR0FBQUEsYUFBQTtBQUVLLE1BQU1HLGdCQUFnQixHQUFHQSxDQUFBLEtBQWU7RUFDN0MsT0FBT1AsYUFBYSxDQUFDUSxXQUFXLENBQUMsQ0FBQztBQUNwQyxDQUFDO0FBQUNULE9BQUEsQ0FBQVEsZ0JBQUEsR0FBQUEsZ0JBQUE7QUFFSyxNQUFNRSxlQUFlLEdBQUdBLENBQUNuQixTQUFpQixFQUFFQyxZQUFvQixLQUFXO0VBQ2hGLE9BQU9TLGFBQWEsQ0FBQ1UsVUFBVSxDQUFDdEIsY0FBYyxDQUFDQyxnQkFBZ0IsQ0FBQ0MsU0FBUyxFQUFFQyxZQUFZLENBQUMsQ0FBQztBQUMzRixDQUFDO0FBQUNRLE9BQUEsQ0FBQVUsZUFBQSxHQUFBQSxlQUFBO0FBRUssTUFBTUUsa0JBQWtCLEdBQUdBLENBQUEsS0FBWTtFQUM1QyxPQUFPWCxhQUFhLENBQUNZLGFBQWEsQ0FBQyxDQUFDO0FBQ3RDLENBQUM7QUFBQ2IsT0FBQSxDQUFBWSxrQkFBQSxHQUFBQSxrQkFBQSJ9