"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchAgent = exports.getAgentIdByConfigName = void 0;
var _constants = require("../utils/constants");
var _errors = require("./errors");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getAgentIdByConfigName = async (configName, client) => {
  var _response$body$ml_con, _response$body$config, _response$body$ml_con2;
  const path = `${_constants.ML_COMMONS_BASE_API}/config/${configName}`;
  const response = await client.request({
    method: 'GET',
    path
  });
  if (!response || !((_response$body$ml_con = response.body.ml_configuration) !== null && _response$body$ml_con !== void 0 && _response$body$ml_con.agent_id || (_response$body$config = response.body.configuration) !== null && _response$body$config !== void 0 && _response$body$config.agent_id)) {
    throw new _errors.AgentNotFoundError(`cannot get agent by config name ${configName} by calling the api: ${path}`);
  }
  return ((_response$body$ml_con2 = response.body.ml_configuration) === null || _response$body$ml_con2 === void 0 ? void 0 : _response$body$ml_con2.agent_id) || response.body.configuration.agent_id;
};
exports.getAgentIdByConfigName = getAgentIdByConfigName;
const searchAgent = async ({
  name
}, client) => {
  const requestParams = {
    query: {
      term: {
        'name.keyword': name
      }
    },
    _source: ['_id'],
    sort: {
      created_time: 'desc'
    },
    size: 1
  };
  const path = `${_constants.ML_COMMONS_BASE_API}/agents/_search`;
  const response = await client.request({
    method: 'GET',
    path,
    body: requestParams
  });
  if (!response || response.body.hits.total.value === 0) {
    throw new _errors.AgentNotFoundError(`cannot find agent by name ${name} by calling the api: ${path}`);
  }
  return response.body.hits.hits[0]._id;
};
exports.searchAgent = searchAgent;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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