"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleError = void 0;
var _opensearch = require("@opensearch-project/opensearch");
var _errors = require("./errors");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// eslint-disable-next-line @typescript-eslint/no-explicit-any
const handleError = (e, res, logger) => {
  logger.error('Error occurred', e.body || e.message);
  // Handle specific type of Errors
  if (e instanceof _errors.AgentNotFoundError) {
    return res.notFound({
      body: 'Agent not found'
    });
  }

  // handle OpenSearch client connection errors
  if (e instanceof _opensearch.errors.NoLivingConnectionsError || e instanceof _opensearch.errors.ConnectionError) {
    return res.customError({
      body: e.message,
      statusCode: 400
    });
  }

  // handle http response error of calling backend API
  if (e.statusCode) {
    if (e.statusCode >= 400 && e.statusCode <= 499) {
      let message = typeof e.body === 'string' ? e.body : JSON.stringify(e.body);
      if (!message) {
        message = e.message;
      }
      return res.customError({
        body: {
          message: message || 'unknown error'
        },
        statusCode: e.statusCode
      });
    } else {
      return res.customError({
        statusCode: e.statusCode
      });
    }
  }

  // Return an general internalError for unhandled server-side issues
  return res.internalError();
};
exports.handleError = handleError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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