"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAgentRoutes = registerAgentRoutes;
var _configSchema = require("@osd/config-schema");
var _llm = require("../../common/constants/llm");
var _error_handler = require("./error_handler");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerAgentRoutes(router, assistantService) {
  router.post({
    path: _llm.AGENT_API.EXECUTE,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.oneOf([_configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentId: _configSchema.schema.string()
      }), _configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentConfigName: _configSchema.schema.string()
      })])
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    try {
      const assistantClient = assistantService.getScopedClient(req, context);
      if ('agentId' in req.query) {
        const response = await assistantClient.executeAgent(req.query.agentId, req.body);
        return res.ok({
          body: response
        });
      }
      const response = await assistantClient.executeAgentByConfigName(req.query.agentConfigName, req.body);
      return res.ok({
        body: response
      });
    } catch (e) {
      return (0, _error_handler.handleError)(e, res, context.assistant_plugin.logger);
    }
  }));
  router.get({
    path: _llm.AGENT_API.CONFIG_EXISTS,
    validate: {
      query: _configSchema.schema.oneOf([_configSchema.schema.object({
        dataSourceId: _configSchema.schema.maybe(_configSchema.schema.string()),
        agentConfigName: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })])
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    try {
      const assistantClient = assistantService.getScopedClient(req, context);
      const promises = Array().concat(req.query.agentConfigName).map(configName => assistantClient.getAgentIdByConfigName(configName));
      const results = await Promise.all(promises);
      const exists = results.every(r => Boolean(r));
      return res.ok({
        body: {
          exists
        }
      });
    } catch (e) {
      return res.ok({
        body: {
          exists: false
        }
      });
    }
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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