"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationCardParser = void 0;
var _csvParserHelper = require("../utils/csv-parser-helper");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const extractIdsFromCsvString = async csv => {
  const lines = await (0, _csvParserHelper.getJsonFromString)(csv);
  return lines.map(line => line.Id).filter(v => v !== null && v !== undefined);
};
const VisualizationCardParser = exports.VisualizationCardParser = {
  id: 'core_visualization',
  async parserProvider(interaction) {
    var _interaction$addition;
    const visualizationOutputs = (_interaction$addition = interaction.additional_info) === null || _interaction$addition === void 0 ? void 0 : _interaction$addition['VisualizationTool.output'];
    if (!visualizationOutputs) {
      return [];
    }
    const visualizationIds = (await Promise.all(visualizationOutputs.map(output => extractIdsFromCsvString(output)))).flatMap(id => id);
    const visOutputs = [...new Set(visualizationIds)]
    /**
     * Empty id will be filtered
     */.filter(id => id).map(id => ({
      type: 'output',
      content: id,
      contentType: 'visualization',
      fullWidth: true,
      suggestedActions: [{
        message: 'View in Visualize',
        actionType: 'view_in_dashboards'
      }]
    }));
    return visOutputs;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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