"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSuggestedActions = exports.BasicInputOutputParser = void 0;
var _dompurify = _interopRequireDefault(require("dompurify"));
var _jsdom = require("jsdom");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const sanitize = content => {
  const window = new _jsdom.JSDOM('').window;
  const DOMPurify = (0, _dompurify.default)(window);
  return DOMPurify.sanitize(content, {
    FORBID_TAGS: ['img']
  }).replace(/!+\[/g, '[');
};
const isStringArray = array => Array.isArray(array) && !!array.length && array.every(item => typeof item === 'string');
const parseSuggestedActions = value => {
  if (!value) {
    return [];
  }
  const suggestedOutputString = value;
  let suggestedActions = [];
  try {
    suggestedActions = JSON.parse(suggestedOutputString);
  } catch (e) {
    suggestedActions = [];
  }
  if (isStringArray(suggestedActions)) {
    return suggestedActions;
  }

  /**
   * Get json-like substring from a string
   *
   *  /\{                  // Match an opening curly brace
   *    .*                 // Match any preleading spaces and letters
   *    response[^\n]*\:   // Match "response" key because suggestion tool uses { response: [action1, action2] }
   *                       // in its prompt so that the parsedResult may contain a "response" field.
   *                       // If prompt changed, the logic here need to change accordingly.
   *    .*                 // Match any any string behind the "response:"
   *  \}/g             // Match a closing curly brace, and 'g' flag for global search
   *
   */
  const jsonPattern = /\{.*response[^\n]*\:.*\}/g;

  /**
   * Use the regular expression to find the JSON substring
   */
  const match = value.match(jsonPattern);
  const matchedResult = match && match[0];
  if (!matchedResult) {
    return [];
  }
  try {
    const parsedResult = JSON.parse(matchedResult);
    if (parsedResult !== null && parsedResult !== void 0 && parsedResult.response && isStringArray(parsedResult.response)) {
      return parsedResult.response;
    }
  } catch (e) {
    return [];
  }
  return [];
};
exports.parseSuggestedActions = parseSuggestedActions;
const BasicInputOutputParser = exports.BasicInputOutputParser = {
  order: 0,
  id: 'output_message',
  async parserProvider(interaction, options) {
    var _reverse$, _interaction$addition;
    /**
     * From UX, only the last interaction need to parse suggestedActions.
     */
    const isLatestInteraction = ((_reverse$ = [...options.interactions].reverse()[0]) === null || _reverse$ === void 0 ? void 0 : _reverse$.interaction_id) === interaction.interaction_id;
    const suggestedActions = isLatestInteraction ? parseSuggestedActions(((_interaction$addition = interaction.additional_info) === null || _interaction$addition === void 0 ? void 0 : _interaction$addition['QuestionSuggestor.output']) || '') : [];
    const inputItem = {
      type: 'input',
      contentType: 'text',
      content: interaction.input
    };
    const outputItems = [{
      type: 'output',
      contentType: 'markdown',
      content: sanitize(interaction.response),
      interactionId: interaction.interaction_id,
      suggestedActions: suggestedActions.filter(item => item).map(item => ({
        actionType: 'send_as_input',
        message: item
      }))
    }];
    return [inputItem, ...outputItems];
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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