"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AssistantPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.AssistantPluginSetup;
  }
});
Object.defineProperty(exports, "AssistantPluginStart", {
  enumerable: true,
  get: function () {
    return _types.AssistantPluginStart;
  }
});
Object.defineProperty(exports, "MessageParser", {
  enumerable: true,
  get: function () {
    return _types.MessageParser;
  }
});
exports.plugin = exports.config = void 0;
var _plugin = require("./plugin");
var _config = require("../common/types/config");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const config = exports.config = {
  exposeToBrowser: {
    chat: true,
    incontextInsight: true,
    next: true,
    text2viz: true,
    alertInsight: true,
    smartAnomalyDetector: true,
    branding: true
  },
  schema: _config.configSchema
};
const plugin = initContext => new _plugin.AssistantPlugin(initContext);
exports.plugin = plugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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