"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertEventStreamToObservable = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const convertEventStreamToObservable = stream => {
  const reader = stream.getReader();
  let observerOutside;
  const output$ = new _rxjs.Observable(observer => {
    observerOutside = observer;
    const decoder = new TextDecoder();
    async function processNextChunk() {
      try {
        const {
          done,
          value
        } = await reader.read();
        if (done) {
          observer.complete();
          return;
        }
        const chunk = decoder.decode(value);
        observer.next(chunk);
        processNextChunk();
      } catch (error) {
        observer.error(error);
      }
    }
    processNextChunk();
  });
  return {
    output$,
    cancel: () => {
      var _observerOutside;
      reader.cancel();
      (_observerOutside = observerOutside) === null || _observerOutside === void 0 || _observerOutside.complete();
    }
  };
};
exports.convertEventStreamToObservable = convertEventStreamToObservable;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfcnhqcyIsInJlcXVpcmUiLCJjb252ZXJ0RXZlbnRTdHJlYW1Ub09ic2VydmFibGUiLCJzdHJlYW0iLCJyZWFkZXIiLCJnZXRSZWFkZXIiLCJvYnNlcnZlck91dHNpZGUiLCJvdXRwdXQkIiwiT2JzZXJ2YWJsZSIsIm9ic2VydmVyIiwiZGVjb2RlciIsIlRleHREZWNvZGVyIiwicHJvY2Vzc05leHRDaHVuayIsImRvbmUiLCJ2YWx1ZSIsInJlYWQiLCJjb21wbGV0ZSIsImNodW5rIiwiZGVjb2RlIiwibmV4dCIsImVycm9yIiwiY2FuY2VsIiwiX29ic2VydmVyT3V0c2lkZSIsImV4cG9ydHMiXSwic291cmNlcyI6WyJzdHJlYW1fdG9fb2JzZXJ2YWJsZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxyXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcclxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcclxuICovXHJcblxyXG5pbXBvcnQgeyBPYnNlcnZhYmxlLCBTdWJzY3JpYmVyIH0gZnJvbSAncnhqcyc7XHJcblxyXG5leHBvcnQgY29uc3QgY29udmVydEV2ZW50U3RyZWFtVG9PYnNlcnZhYmxlID0gKFxyXG4gIHN0cmVhbTogUmVhZGFibGVTdHJlYW1cclxuKToge1xyXG4gIG91dHB1dCQ6IE9ic2VydmFibGU8c3RyaW5nPjtcclxuICBjYW5jZWw6ICgpID0+IHZvaWQ7XHJcbn0gPT4ge1xyXG4gIGNvbnN0IHJlYWRlciA9IHN0cmVhbS5nZXRSZWFkZXIoKTtcclxuICBsZXQgb2JzZXJ2ZXJPdXRzaWRlOiBTdWJzY3JpYmVyPHN0cmluZz4gfCBudWxsO1xyXG4gIGNvbnN0IG91dHB1dCQgPSBuZXcgT2JzZXJ2YWJsZTxzdHJpbmc+KChvYnNlcnZlcikgPT4ge1xyXG4gICAgb2JzZXJ2ZXJPdXRzaWRlID0gb2JzZXJ2ZXI7XHJcbiAgICBjb25zdCBkZWNvZGVyID0gbmV3IFRleHREZWNvZGVyKCk7XHJcblxyXG4gICAgYXN5bmMgZnVuY3Rpb24gcHJvY2Vzc05leHRDaHVuaygpIHtcclxuICAgICAgdHJ5IHtcclxuICAgICAgICBjb25zdCB7IGRvbmUsIHZhbHVlIH0gPSBhd2FpdCByZWFkZXIucmVhZCgpO1xyXG5cclxuICAgICAgICBpZiAoZG9uZSkge1xyXG4gICAgICAgICAgb2JzZXJ2ZXIuY29tcGxldGUoKTtcclxuICAgICAgICAgIHJldHVybjtcclxuICAgICAgICB9XHJcblxyXG4gICAgICAgIGNvbnN0IGNodW5rID0gZGVjb2Rlci5kZWNvZGUodmFsdWUpO1xyXG5cclxuICAgICAgICBvYnNlcnZlci5uZXh0KGNodW5rKTtcclxuXHJcbiAgICAgICAgcHJvY2Vzc05leHRDaHVuaygpO1xyXG4gICAgICB9IGNhdGNoIChlcnJvcikge1xyXG4gICAgICAgIG9ic2VydmVyLmVycm9yKGVycm9yKTtcclxuICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIHByb2Nlc3NOZXh0Q2h1bmsoKTtcclxuICB9KTtcclxuXHJcbiAgcmV0dXJuIHtcclxuICAgIG91dHB1dCQsXHJcbiAgICBjYW5jZWw6ICgpID0+IHtcclxuICAgICAgcmVhZGVyLmNhbmNlbCgpO1xyXG4gICAgICBvYnNlcnZlck91dHNpZGU/LmNvbXBsZXRlKCk7XHJcbiAgICB9LFxyXG4gIH07XHJcbn07XHJcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsS0FBQSxHQUFBQyxPQUFBO0FBTEE7QUFDQTtBQUNBO0FBQ0E7O0FBSU8sTUFBTUMsOEJBQThCLEdBQ3pDQyxNQUFzQixJQUluQjtFQUNILE1BQU1DLE1BQU0sR0FBR0QsTUFBTSxDQUFDRSxTQUFTLENBQUMsQ0FBQztFQUNqQyxJQUFJQyxlQUEwQztFQUM5QyxNQUFNQyxPQUFPLEdBQUcsSUFBSUMsZ0JBQVUsQ0FBVUMsUUFBUSxJQUFLO0lBQ25ESCxlQUFlLEdBQUdHLFFBQVE7SUFDMUIsTUFBTUMsT0FBTyxHQUFHLElBQUlDLFdBQVcsQ0FBQyxDQUFDO0lBRWpDLGVBQWVDLGdCQUFnQkEsQ0FBQSxFQUFHO01BQ2hDLElBQUk7UUFDRixNQUFNO1VBQUVDLElBQUk7VUFBRUM7UUFBTSxDQUFDLEdBQUcsTUFBTVYsTUFBTSxDQUFDVyxJQUFJLENBQUMsQ0FBQztRQUUzQyxJQUFJRixJQUFJLEVBQUU7VUFDUkosUUFBUSxDQUFDTyxRQUFRLENBQUMsQ0FBQztVQUNuQjtRQUNGO1FBRUEsTUFBTUMsS0FBSyxHQUFHUCxPQUFPLENBQUNRLE1BQU0sQ0FBQ0osS0FBSyxDQUFDO1FBRW5DTCxRQUFRLENBQUNVLElBQUksQ0FBQ0YsS0FBSyxDQUFDO1FBRXBCTCxnQkFBZ0IsQ0FBQyxDQUFDO01BQ3BCLENBQUMsQ0FBQyxPQUFPUSxLQUFLLEVBQUU7UUFDZFgsUUFBUSxDQUFDVyxLQUFLLENBQUNBLEtBQUssQ0FBQztNQUN2QjtJQUNGO0lBRUFSLGdCQUFnQixDQUFDLENBQUM7RUFDcEIsQ0FBQyxDQUFDO0VBRUYsT0FBTztJQUNMTCxPQUFPO0lBQ1BjLE1BQU0sRUFBRUEsQ0FBQSxLQUFNO01BQUEsSUFBQUMsZ0JBQUE7TUFDWmxCLE1BQU0sQ0FBQ2lCLE1BQU0sQ0FBQyxDQUFDO01BQ2YsQ0FBQUMsZ0JBQUEsR0FBQWhCLGVBQWUsY0FBQWdCLGdCQUFBLGVBQWZBLGdCQUFBLENBQWlCTixRQUFRLENBQUMsQ0FBQztJQUM3QjtFQUNGLENBQUM7QUFDSCxDQUFDO0FBQUNPLE9BQUEsQ0FBQXJCLDhCQUFBLEdBQUFBLDhCQUFBIn0=