"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamSerializer = exports.streamDeserializer = void 0;
var _eventsourceParser = require("eventsource-parser");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const separators = `\n\n`;
const prefix = 'data: ';
const streamSerializer = chunk => {
  const {
    event,
    data
  } = chunk;
  let chunkString = '';
  if (event) {
    chunkString += `event: ${event}\n`;
  }
  chunkString += `${prefix}${JSON.stringify(data)}${separators}`;
  return chunkString;
};
exports.streamSerializer = streamSerializer;
const streamDeserializer = content => {
  const streamChunks = [];
  const parser = (0, _eventsourceParser.createParser)({
    onEvent(message) {
      try {
        const dataPayload = JSON.parse(message.data);
        streamChunks.push({
          ...message,
          data: dataPayload
        });
      } catch (e) {
        streamChunks.push({
          event: 'error',
          data: e.message
        });
      }
    },
    onError(error) {
      streamChunks.push({
        event: 'error',
        data: error.message
      });
    }
  });
  parser.feed(content);
  return streamChunks;
};
exports.streamDeserializer = streamDeserializer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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