"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  chat: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    trace: _configSchema.schema.boolean({
      defaultValue: true
    }),
    feedback: _configSchema.schema.boolean({
      defaultValue: true
    }),
    allowRenameConversation: _configSchema.schema.boolean({
      defaultValue: true
    }),
    deleteConversation: _configSchema.schema.boolean({
      defaultValue: true
    }),
    regenerateMessage: _configSchema.schema.boolean({
      defaultValue: true
    }),
    showConversationHistory: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  incontextInsight: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  next: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  text2viz: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  alertInsight: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  smartAnomalyDetector: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  branding: _configSchema.schema.object({
    label: _configSchema.schema.maybe(_configSchema.schema.string()),
    logo: _configSchema.schema.maybe(_configSchema.schema.object({
      gradient: _configSchema.schema.maybe(_configSchema.schema.string()),
      gray: _configSchema.schema.maybe(_configSchema.schema.string()),
      white: _configSchema.schema.maybe(_configSchema.schema.string())
    }))
  })
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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