"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEXT2VIZ_API = exports.TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = exports.TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = exports.TEXT2VEGA_INPUT_SIZE_LIMIT = exports.TEXT2PPL_AGENT_CONFIG_ID = exports.SUMMARY_ASSISTANT_API = exports.NOTEBOOK_PREFIX = exports.NOTEBOOK_API = exports.DSL_SEARCH = exports.DSL_BASE = exports.DEFAULT_USER_NAME = exports.DATA2SUMMARY_AGENT_CONFIG_ID = exports.ASSISTANT_API = exports.API_BASE = exports.AGENT_API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_BASE = exports.API_BASE = '/api/assistant';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const NOTEBOOK_PREFIX = exports.NOTEBOOK_PREFIX = '/api/observability/notebooks';
const ASSISTANT_API = exports.ASSISTANT_API = {
  SEND_MESSAGE: `${API_BASE}/send_message`,
  CONVERSATION: `${API_BASE}/conversation`,
  CONVERSATIONS: `${API_BASE}/conversations`,
  FEEDBACK: `${API_BASE}/feedback`,
  ABORT_AGENT_EXECUTION: `${API_BASE}/abort`,
  REGENERATE: `${API_BASE}/regenerate`,
  TRACE: `${API_BASE}/trace`,
  ACCOUNT: `${API_BASE}/account`
};
const TEXT2VIZ_API = exports.TEXT2VIZ_API = {
  TEXT2PPL: `${API_BASE}/text2ppl`,
  TEXT2VEGA: `${API_BASE}/text2vega`
};
const AGENT_API = exports.AGENT_API = {
  EXECUTE: `${API_BASE}/agent/_execute`,
  CONFIG_EXISTS: `${API_BASE}/agent_config/_exists`
};
const SUMMARY_ASSISTANT_API = exports.SUMMARY_ASSISTANT_API = {
  SUMMARIZE: `${API_BASE}/summary`,
  INSIGHT: `${API_BASE}/insight`,
  DATA2SUMMARY: `${API_BASE}/data2summary`
};
const NOTEBOOK_API = exports.NOTEBOOK_API = {
  CREATE_NOTEBOOK: `${NOTEBOOK_PREFIX}/note/savedNotebook`,
  SET_PARAGRAPH: `${NOTEBOOK_PREFIX}/savedNotebook/set_paragraphs`
};
const DEFAULT_USER_NAME = exports.DEFAULT_USER_NAME = 'User';
const TEXT2VEGA_INPUT_SIZE_LIMIT = exports.TEXT2VEGA_INPUT_SIZE_LIMIT = 400;
const TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = exports.TEXT2VEGA_RULE_BASED_AGENT_CONFIG_ID = 'os_text2vega';
const TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = exports.TEXT2VEGA_WITH_INSTRUCTIONS_AGENT_CONFIG_ID = 'os_text2vega_with_instructions';
const TEXT2PPL_AGENT_CONFIG_ID = exports.TEXT2PPL_AGENT_CONFIG_ID = 'os_query_assist_ppl';
const DATA2SUMMARY_AGENT_CONFIG_ID = exports.DATA2SUMMARY_AGENT_CONFIG_ID = 'os_data2summary';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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